/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.metrics.reporter;

import io.dropwizard.metrics5.MetricAttribute;
import io.dropwizard.metrics5.MetricFilter;
import io.dropwizard.metrics5.MetricRegistry;
import io.opencensus.contrib.zpages.ZPageHandlers;
import java.io.IOException;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuxeo.runtime.metrics.AbstractMetricsReporter;

public class ZPageReporter
extends AbstractMetricsReporter {
    private static final Logger log = LogManager.getLogger(ZPageReporter.class);
    public static final String PORT = "port";
    public static final String DEFAULT_PORT = "8887";
    protected boolean activated;

    @Override
    public void start(MetricRegistry registry, MetricFilter filter, Set<MetricAttribute> deniedExpansions) {
        if (this.activated) {
            log.debug("Already activated");
            return;
        }
        int port = Integer.parseInt(this.options.getOrDefault(PORT, DEFAULT_PORT));
        log.warn("Creating ZPage reporter on port: {}", (Object)port);
        try {
            ZPageHandlers.startHttpServerAndRegisterAll((int)port);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Cannot start ZPage server on port: " + port, e);
        }
        this.activated = true;
    }

    @Override
    public void stop() {
        log.debug("Stop reporting");
    }
}

