/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.migration;

import java.util.ArrayList;
import java.util.Arrays;
import javax.inject.Inject;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.nuxeo.common.xmap.registry.MapRegistry;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.migration.MigrationDescriptor;
import org.nuxeo.runtime.migration.MigrationService;
import org.nuxeo.runtime.test.runner.Deploy;
import org.nuxeo.runtime.test.runner.Deploys;
import org.nuxeo.runtime.test.runner.Features;
import org.nuxeo.runtime.test.runner.FeaturesRunner;
import org.nuxeo.runtime.test.runner.RuntimeFeature;

@RunWith(value=FeaturesRunner.class)
@Features(value={RuntimeFeature.class})
@Deploys(value={@Deploy(value={"org.nuxeo.runtime.kv"}), @Deploy(value={"org.nuxeo.runtime.cluster"}), @Deploy(value={"org.nuxeo.runtime.migration"})})
public class TestMigrationDescriptor {
    @Inject
    protected MigrationService migrationService;

    protected MigrationDescriptor getDescriptor(String id) {
        return Framework.getRuntime().getComponentManager().getExtensionPointRegistry("org.nuxeo.runtime.migration.MigrationService", "configuration").map(MapRegistry.class::cast).get().getContribution(id).map(MigrationDescriptor.class::cast).orElse(null);
    }

    @Test
    @Deploy(value={"org.nuxeo.runtime.migration.tests:OSGI-INF/test-migration-descriptor.xml"})
    public void testRead() throws Exception {
        MigrationDescriptor desc = this.getDescriptor("my_migration");
        Assert.assertEquals((Object)"my_migration", (Object)desc.id);
        Assert.assertEquals((Object)"my_migration", (Object)desc.descriptionLabel);
        Assert.assertEquals((Object)"My Migration", (Object)desc.description);
        Assert.assertEquals(String.class, (Object)desc.klass);
        Assert.assertEquals((Object)"v2", (Object)desc.defaultState);
        Assert.assertEquals(Arrays.asList("v1", "v2", "v3"), new ArrayList(desc.states.keySet()));
        MigrationDescriptor.MigrationStateDescriptor state = (MigrationDescriptor.MigrationStateDescriptor)desc.states.get("v1");
        Assert.assertEquals((Object)"v1", (Object)state.id);
        Assert.assertEquals((Object)"my_migration.state.v1", (Object)state.descriptionLabel);
        Assert.assertEquals((Object)"Initial state", (Object)state.description);
        state = (MigrationDescriptor.MigrationStateDescriptor)desc.states.get("v2");
        Assert.assertEquals((Object)"v2", (Object)state.id);
        Assert.assertEquals((Object)"my_migration.state.v2", (Object)state.descriptionLabel);
        Assert.assertEquals((Object)"Second version", (Object)state.description);
        state = (MigrationDescriptor.MigrationStateDescriptor)desc.states.get("v3");
        Assert.assertEquals((Object)"v3", (Object)state.id);
        Assert.assertEquals((Object)"my_migration.state.v3", (Object)state.descriptionLabel);
        Assert.assertEquals((Object)"Third version", (Object)state.description);
        Assert.assertEquals(Arrays.asList("first", "second"), new ArrayList(desc.steps.keySet()));
        MigrationDescriptor.MigrationStepDescriptor step = (MigrationDescriptor.MigrationStepDescriptor)desc.steps.get("first");
        Assert.assertEquals((Object)"first", (Object)step.id);
        Assert.assertEquals((Object)"v1", (Object)step.fromState);
        Assert.assertEquals((Object)"v2", (Object)step.toState);
        Assert.assertEquals((Object)"my_migration.step.first", (Object)step.descriptionLabel);
        Assert.assertEquals((Object)"First step of the migration, from v1 to v2", (Object)step.description);
        step = (MigrationDescriptor.MigrationStepDescriptor)desc.steps.get("second");
        Assert.assertEquals((Object)"second", (Object)step.id);
        Assert.assertEquals((Object)"v2", (Object)step.fromState);
        Assert.assertEquals((Object)"v3", (Object)step.toState);
        Assert.assertEquals((Object)"my_migration.step.second", (Object)step.descriptionLabel);
        Assert.assertEquals((Object)"Second step of the migration, from v2 to v3", (Object)step.description);
    }

    @Test
    @Deploys(value={@Deploy(value={"org.nuxeo.runtime.migration.tests:OSGI-INF/test-migration-descriptor.xml"}), @Deploy(value={"org.nuxeo.runtime.migration.tests:OSGI-INF/test-migration-descriptor2.xml"})})
    public void testMerge() throws Exception {
        MigrationDescriptor desc = this.getDescriptor("my_migration");
        Assert.assertEquals((Object)"my_migration", (Object)desc.id);
        Assert.assertEquals((Object)"newLabel", (Object)desc.descriptionLabel);
        Assert.assertEquals((Object)"New Descr", (Object)desc.description);
        Assert.assertEquals(Boolean.class, (Object)desc.klass);
        Assert.assertEquals((Object)"v4", (Object)desc.defaultState);
        Assert.assertEquals(Arrays.asList("v1", "v2", "v3", "v4"), new ArrayList(desc.states.keySet()));
        MigrationDescriptor.MigrationStateDescriptor state = (MigrationDescriptor.MigrationStateDescriptor)desc.states.get("v4");
        Assert.assertEquals((Object)"v4", (Object)state.id);
        Assert.assertEquals((Object)"my_migration.state.v4", (Object)state.descriptionLabel);
        Assert.assertEquals((Object)"New State", (Object)state.description);
        Assert.assertEquals(Arrays.asList("first", "second", "third"), new ArrayList(desc.steps.keySet()));
        MigrationDescriptor.MigrationStepDescriptor step = (MigrationDescriptor.MigrationStepDescriptor)desc.steps.get("third");
        Assert.assertEquals((Object)"third", (Object)step.id);
        Assert.assertEquals((Object)"v3", (Object)step.fromState);
        Assert.assertEquals((Object)"v4", (Object)step.toState);
        Assert.assertEquals((Object)"my_migration.step.third", (Object)step.descriptionLabel);
        Assert.assertEquals((Object)"Third step of the migration, from v3 to v4", (Object)step.description);
    }
}

