/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.mongodb;

import com.mongodb.MongoClient;
import com.mongodb.MongoClientOptions;
import com.mongodb.MongoClientURI;
import com.mongodb.ServerAddress;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.MongoIterable;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.util.function.Consumer;
import java.util.stream.StreamSupport;
import javax.net.ssl.SSLContext;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.SSLContexts;
import org.nuxeo.runtime.mongodb.MongoDBConnectionConfig;

public class MongoDBConnectionHelper {
    private static final Log log = LogFactory.getLog(MongoDBConnectionHelper.class);
    private static final String DB_DEFAULT = "nuxeo";
    private static final int MONGODB_OPTION_CONNECTION_TIMEOUT_MS = 30000;
    private static final int MONGODB_OPTION_SOCKET_TIMEOUT_MS = 60000;

    private MongoDBConnectionHelper() {
    }

    public static MongoClient newMongoClient(String server) {
        MongoDBConnectionConfig config = new MongoDBConnectionConfig();
        config.server = server;
        return MongoDBConnectionHelper.newMongoClient(config);
    }

    public static MongoClient newMongoClient(MongoDBConnectionConfig config) {
        return MongoDBConnectionHelper.newMongoClient(config, null);
    }

    public static MongoClient newMongoClient(MongoDBConnectionConfig config, Consumer<MongoClientOptions.Builder> optionsConsumer) {
        String server = config.server;
        if (StringUtils.isBlank((CharSequence)server)) {
            throw new RuntimeException("Missing <server> in MongoDB descriptor");
        }
        MongoClientOptions.Builder optionsBuilder = MongoClientOptions.builder().connectTimeout(30000).socketTimeout(60000).description("Nuxeo");
        SSLContext sslContext = MongoDBConnectionHelper.getSSLContext(config);
        if (sslContext == null) {
            if (config.ssl != null) {
                optionsBuilder.sslEnabled(config.ssl.booleanValue());
            }
        } else {
            optionsBuilder.sslEnabled(true);
            optionsBuilder.sslContext(sslContext);
        }
        if (optionsConsumer != null) {
            optionsConsumer.accept(optionsBuilder);
        }
        MongoClient client = server.startsWith("mongodb://") ? new MongoClient(new MongoClientURI(server, optionsBuilder)) : new MongoClient(new ServerAddress(server), optionsBuilder.build());
        if (log.isDebugEnabled()) {
            log.debug((Object)("MongoClient initialized with options: " + client.getMongoClientOptions().toString()));
        }
        return client;
    }

    protected static SSLContext getSSLContext(MongoDBConnectionConfig config) {
        try {
            KeyStore trustStore = MongoDBConnectionHelper.loadKeyStore(config.trustStorePath, config.trustStorePassword, config.trustStoreType);
            KeyStore keyStore = MongoDBConnectionHelper.loadKeyStore(config.keyStorePath, config.keyStorePassword, config.keyStoreType);
            if (trustStore == null && keyStore == null) {
                return null;
            }
            SSLContextBuilder sslContextBuilder = SSLContexts.custom();
            if (trustStore != null) {
                sslContextBuilder.loadTrustMaterial(trustStore, null);
            }
            if (keyStore != null) {
                sslContextBuilder.loadKeyMaterial(keyStore, null);
            }
            return sslContextBuilder.build();
        }
        catch (IOException | GeneralSecurityException e) {
            throw new RuntimeException("Cannot setup SSL context: " + config, e);
        }
    }

    protected static KeyStore loadKeyStore(String path, String password, String type) throws GeneralSecurityException, IOException {
        if (StringUtils.isBlank((CharSequence)path)) {
            return null;
        }
        String keyStoreType = (String)StringUtils.defaultIfBlank((CharSequence)type, (CharSequence)KeyStore.getDefaultType());
        KeyStore keyStore = KeyStore.getInstance(keyStoreType);
        char[] passwordChars = StringUtils.isBlank((CharSequence)password) ? null : password.toCharArray();
        try (InputStream is = Files.newInputStream(Paths.get(path, new String[0]), new OpenOption[0]);){
            keyStore.load(is, passwordChars);
        }
        return keyStore;
    }

    public static MongoDatabase getDatabase(MongoClient mongoClient, String dbname) {
        if (StringUtils.isBlank((CharSequence)dbname)) {
            dbname = DB_DEFAULT;
        }
        return mongoClient.getDatabase(dbname);
    }

    public static boolean hasCollection(MongoDatabase mongoDatabase, String collection) {
        MongoIterable collections = mongoDatabase.listCollectionNames();
        boolean found = StreamSupport.stream(collections.spliterator(), false).anyMatch(collection::equals);
        return found && mongoDatabase.getCollection(collection).count() > 0L;
    }
}

