/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.stream;

import com.codahale.metrics.Counter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.SharedMetricRegistries;
import org.nuxeo.lib.stream.computation.log.ComputationRunner;
import org.nuxeo.runtime.management.api.Probe;
import org.nuxeo.runtime.management.api.ProbeStatus;

public class StreamProbe
implements Probe {
    protected static final String FAILURE_MESSAGE = "%d computations have been terminated after failure. This Nuxeo instance must be restarted within the stream retention period.";
    protected Counter globalFailureCount;

    public ProbeStatus run() {
        long failures = this.getFailures();
        if (failures > 0L) {
            return ProbeStatus.newFailure((String)String.format(FAILURE_MESSAGE, failures));
        }
        return ProbeStatus.newSuccess((String)"No failure");
    }

    protected long getFailures() {
        if (this.globalFailureCount == null) {
            MetricRegistry registry = SharedMetricRegistries.getOrCreate((String)"org.nuxeo.runtime.metrics.MetricsService");
            this.globalFailureCount = registry.counter(ComputationRunner.GLOBAL_FAILURE_COUNT_REGISTRY_NAME);
        }
        return this.globalFailureCount.getCount();
    }
}

