/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.stream.tests;

import javax.inject.Inject;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.nuxeo.runtime.kafka.KafkaConfigService;
import org.nuxeo.runtime.test.runner.Deploy;
import org.nuxeo.runtime.test.runner.Deploys;
import org.nuxeo.runtime.test.runner.Features;
import org.nuxeo.runtime.test.runner.FeaturesRunner;
import org.nuxeo.runtime.test.runner.RuntimeFeature;

@RunWith(value=FeaturesRunner.class)
@Features(value={RuntimeFeature.class})
@Deploys(value={@Deploy(value={"org.nuxeo.runtime.stream"}), @Deploy(value={"org.nuxeo.runtime.stream:test-kafka-config-contrib.xml"})})
public class TestKafkaConfigService {
    @Inject
    public KafkaConfigService service;

    @Test
    public void testService() {
        Assert.assertNotNull((Object)this.service);
        Assert.assertFalse((boolean)this.service.listConfigNames().isEmpty());
        Assert.assertEquals((long)3L, (long)this.service.listConfigNames().size());
        String config1 = "default";
        Assert.assertNotNull((Object)this.service.getConsumerProperties(config1));
        Assert.assertNotNull((Object)this.service.getProducerProperties(config1));
        Assert.assertEquals((Object)"localhost:9092", (Object)this.service.getProducerProperties(config1).getProperty("bootstrap.servers"));
        Assert.assertNotEquals((Object)"RANDOM()", (Object)this.service.getTopicPrefix(config1));
        String config2 = "config2";
        Assert.assertNotNull((Object)this.service.getConsumerProperties(config2));
        Assert.assertNotNull((Object)this.service.getProducerProperties(config2));
        Assert.assertEquals((Object)"foo", (Object)this.service.getTopicPrefix(config2));
    }
}

