/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.stream.tests;

import java.util.EnumSet;
import javax.inject.Inject;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.nuxeo.lib.stream.codec.Codec;
import org.nuxeo.lib.stream.codec.NoCodec;
import org.nuxeo.lib.stream.computation.Record;
import org.nuxeo.runtime.codec.CodecService;
import org.nuxeo.runtime.stream.RuntimeStreamFeature;
import org.nuxeo.runtime.test.runner.Features;
import org.nuxeo.runtime.test.runner.FeaturesRunner;

@RunWith(value=FeaturesRunner.class)
@Features(value={RuntimeStreamFeature.class})
public class TestCodecService {
    @Inject
    public CodecService service;

    @Test
    public void testService() {
        Assert.assertNotNull((Object)this.service);
    }

    @Test
    public void testCodec() throws Exception {
        Record record = Record.of((String)"key", (byte[])"value".getBytes("UTF-8"));
        record.setFlags(EnumSet.of(Record.Flag.COMMIT, Record.Flag.POISON_PILL));
        Codec codec = this.service.getCodec("java", Record.class);
        this.checkCodec(record, (Codec<Record>)codec, 90);
        codec = this.service.getCodec("avro", Record.class);
        this.checkCodec(record, (Codec<Record>)codec, 33);
        codec = this.service.getCodec("avroBinary", Record.class);
        this.checkCodec(record, (Codec<Record>)codec, 23);
        codec = this.service.getCodec("avroJson", Record.class);
        this.checkCodec(record, (Codec<Record>)codec, 127);
        codec = this.service.getCodec("java", Record.class);
        this.checkCodec(record, (Codec<Record>)codec, 90);
        codec = this.service.getCodec("legacy", Record.class);
        Assert.assertEquals((Object)NoCodec.NO_CODEC, (Object)codec);
    }

    private void checkCodec(Record src, Codec<Record> codec, int expectedSize) {
        Assert.assertNotNull(codec);
        byte[] data = codec.encode((Object)src);
        Record dest = (Record)codec.decode(data);
        Assert.assertEquals((Object)src, (Object)dest);
        Assert.assertEquals((long)expectedSize, (long)data.length);
    }
}

