/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.stream.tests;

import java.io.File;
import java.nio.charset.StandardCharsets;
import java.util.EnumSet;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.junit.runner.RunWith;
import org.nuxeo.lib.stream.codec.Codec;
import org.nuxeo.lib.stream.computation.Record;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.codec.CodecService;
import org.nuxeo.runtime.stream.RuntimeStreamFeature;
import org.nuxeo.runtime.stream.tests.TestMessage;
import org.nuxeo.runtime.test.runner.Deploy;
import org.nuxeo.runtime.test.runner.Deploys;
import org.nuxeo.runtime.test.runner.Features;
import org.nuxeo.runtime.test.runner.FeaturesRunner;

@RunWith(value=FeaturesRunner.class)
@Features(value={RuntimeStreamFeature.class})
@Deploys(value={@Deploy(value={"org.nuxeo.runtime.stream"}), @Deploy(value={"org.nuxeo.runtime.stream:test-codec-contrib.xml"})})
public class TestAvroRecordCodec {
    @Rule
    public TemporaryFolder folder = new TemporaryFolder(new File(FeaturesRunner.getBuildDirectory()));
    public static final String SCHEMA_REGISTRY_URL_PROP = "confluent.schema_registry.urls";
    public static final String SCHEMA_REGISTRY_URL_DEFAULT = "http://localhost:8081";
    public static final String CONFLUENT_PROP = "confluent";
    protected final Codec<TestMessage> messageCodec = ((CodecService)Framework.getService(CodecService.class)).getCodec("avroBinary", TestMessage.class);

    public static void assumeConfluentRegistryEnabled() {
        Assume.assumeTrue((String)"Skip Confluent tests", (boolean)"true".equals(System.getProperty(CONFLUENT_PROP)));
    }

    public static String getConfluentRegistryUrls() {
        String url = System.getProperty(SCHEMA_REGISTRY_URL_PROP, SCHEMA_REGISTRY_URL_DEFAULT);
        if (url == null || url.isEmpty()) {
            url = SCHEMA_REGISTRY_URL_DEFAULT;
        }
        return url;
    }

    @Test
    public void testAvroRecordCodec() throws Exception {
        TestAvroRecordCodec.assumeConfluentRegistryEnabled();
        Record src = this.getRecord();
        Codec codec = ((CodecService)Framework.getService(CodecService.class)).getCodec("testMessageFlat", Record.class);
        byte[] data = codec.encode((Object)src);
        Record dest = (Record)codec.decode(data);
        this.testCodec(src, (Codec<Record>)codec);
    }

    protected Record testCodec(Record src, Codec<Record> codec) {
        byte[] data = codec.encode((Object)src);
        Record dest = (Record)codec.decode(data);
        Assert.assertEquals((Object)src.getKey(), (Object)dest.getKey());
        Assert.assertEquals((long)src.getWatermark(), (long)dest.getWatermark());
        Assert.assertEquals((Object)src, (Object)dest);
        TestMessage msgSrc = (TestMessage)this.messageCodec.decode(src.getData());
        TestMessage msgDest = (TestMessage)this.messageCodec.decode(dest.getData());
        Assert.assertEquals((Object)msgSrc, (Object)msgDest);
        byte[] data2 = codec.encode((Object)dest);
        Record dest2 = (Record)codec.decode(data2);
        Assert.assertEquals((Object)src, (Object)dest2);
        Assert.assertEquals((String)String.format("%s\n%s", this.overview(data), this.overview(data2)), (long)data.length, (long)data2.length);
        return dest2;
    }

    protected Record getRecord() {
        TestMessage message = new TestMessage("foo", 1234L, true);
        Record src = Record.of((String)"key", (byte[])this.messageCodec.encode((Object)message));
        src.setFlags(EnumSet.of(Record.Flag.COMMIT, Record.Flag.USER2, Record.Flag.DEFAULT));
        return src;
    }

    protected String overview(byte[] data) {
        String overview = new String(data, StandardCharsets.UTF_8);
        return overview;
    }
}

