/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.test;

import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;

public class ResourceHelper {
    public static URL getResource(String name) {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        String callerName = Thread.currentThread().getStackTrace()[2].getClassName();
        String relativePath = callerName.replace('.', '/').concat(".class");
        String fullPath = loader.getResource(relativePath).getPath();
        String basePath = fullPath.substring(0, fullPath.indexOf(relativePath));
        try {
            Enumeration<URL> resources = loader.getResources(name);
            while (resources.hasMoreElements()) {
                URL resource = resources.nextElement();
                if (!resource.getPath().startsWith(basePath)) continue;
                return resource;
            }
        }
        catch (IOException e) {
            return null;
        }
        return loader.getResource(name);
    }
}

