/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.test.runner;

import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.lang3.SystemUtils;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.rules.MethodRule;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.Statement;
import org.nuxeo.runtime.RuntimeServiceException;
import org.nuxeo.runtime.test.runner.FeaturesRunner;
import org.nuxeo.runtime.test.runner.RunnerFeature;

public class ConditionalIgnoreRule
implements TestRule,
MethodRule {
    @Inject
    private RunNotifier runNotifier;
    @Inject
    private FeaturesRunner runner;

    public Statement apply(final Statement base, final Description description) {
        Ignore ignore = this.runner.getConfig(Ignore.class);
        final Class<? extends Condition> conditionType = ignore.condition();
        if (conditionType == null) {
            return base;
        }
        return new Statement(){

            public void evaluate() throws Throwable {
                Condition condition = ConditionalIgnoreRule.this.instantiateCondition(conditionType);
                if (condition.supportsClassRule() && condition.shouldIgnore()) {
                    ConditionalIgnoreRule.this.runNotifier.fireTestIgnored(description);
                } else {
                    base.evaluate();
                }
            }
        };
    }

    public Statement apply(final Statement base, FrameworkMethod frameworkMethod, final Object target) {
        Ignore ignore = this.runner.getConfig(frameworkMethod, Ignore.class);
        final Class<? extends Condition> conditionType = ignore.condition();
        if (conditionType == null) {
            return base;
        }
        final Class<?> type = target.getClass();
        final Method method = frameworkMethod.getMethod();
        final Description description = Description.createTestDescription(type, (String)method.getName(), (Annotation[])method.getAnnotations());
        return new Statement(){

            public void evaluate() throws Throwable {
                if (ConditionalIgnoreRule.this.newCondition(type, method, target, conditionType).shouldIgnore()) {
                    ConditionalIgnoreRule.this.runNotifier.fireTestIgnored(description);
                } else {
                    base.evaluate();
                }
            }
        };
    }

    protected Condition newCondition(Class<?> type, Method method, Object target, Class<? extends Condition> conditionType) {
        Condition condition = this.instantiateCondition(conditionType);
        this.injectCondition(type, method, target, condition);
        return condition;
    }

    protected Condition instantiateCondition(Class<? extends Condition> conditionType) {
        Condition condition;
        try {
            condition = conditionType.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ReflectiveOperationException cause) {
            throw new RuntimeServiceException("Cannot instantiate condition of type " + conditionType, (Throwable)cause);
        }
        return condition;
    }

    protected void injectCondition(Class<?> type, Method method, Object target, Condition condition) {
        RuntimeServiceException errors = new RuntimeServiceException("Cannot inject condition parameters in " + condition.getClass());
        for (Field eachField : condition.getClass().getDeclaredFields()) {
            if (!eachField.isAnnotationPresent(Inject.class)) continue;
            Object eachValue = null;
            if (eachField.isAnnotationPresent(Named.class)) {
                String name = eachField.getAnnotation(Named.class).value();
                if ("type".equals(name)) {
                    eachValue = type;
                } else if ("target".equals(name)) {
                    eachValue = target;
                } else if ("method".equals(name)) {
                    eachValue = method;
                }
            } else {
                Class<?> eachType = eachField.getType();
                if (eachType.equals(Class.class)) {
                    eachValue = type;
                } else if (eachType.equals(Object.class)) {
                    eachValue = target;
                } else if (eachType.equals(Method.class)) {
                    eachValue = method;
                }
            }
            if (eachValue == null) continue;
            eachField.setAccessible(true);
            try {
                eachField.set(condition, eachValue);
            }
            catch (IllegalAccessException | IllegalArgumentException cause) {
                errors.addSuppressed((Throwable)new RuntimeServiceException("Cannot inject " + eachField.getName(), (Throwable)cause));
            }
        }
        if (errors.getSuppressed().length > 0) {
            throw errors;
        }
        this.runner.getInjector().injectMembers((Object)condition);
    }

    public static final class IgnoreWindows
    implements Condition {
        @Override
        public boolean shouldIgnore() {
            return SystemUtils.IS_OS_WINDOWS;
        }

        @Override
        public boolean supportsClassRule() {
            return true;
        }
    }

    public static final class IgnoreLongRunning
    implements Condition {
        @Override
        public boolean shouldIgnore() {
            return true;
        }
    }

    @Deprecated(since="11.1")
    public static final class IgnoreIsolated
    implements Condition {
        boolean isIsolated = "org.nuxeo.runtime.testsuite.IsolatedClassloader".equals(this.getClass().getClassLoader().getClass().getName());

        @Override
        public boolean shouldIgnore() {
            return this.isIsolated;
        }
    }

    public static interface Condition {
        public boolean shouldIgnore();

        default public boolean supportsClassRule() {
            return false;
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE, ElementType.METHOD})
    public static @interface Ignore {
        public Class<? extends Condition> condition();

        public String cause() default "";
    }

    public static class Feature
    implements RunnerFeature {
        protected static final ConditionalIgnoreRule rule = new ConditionalIgnoreRule();

        @Rule
        public MethodRule methodRule() {
            return rule;
        }

        @ClassRule
        public static TestRule testRule() {
            return rule;
        }
    }
}

