/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.test;

import io.github.classgraph.ClassGraph;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.nuxeo.common.Environment;
import org.nuxeo.osgi.BundleFile;
import org.nuxeo.osgi.BundleImpl;
import org.nuxeo.osgi.DirectoryBundleFile;
import org.nuxeo.osgi.JarBundleFile;
import org.nuxeo.osgi.OSGiAdapter;
import org.nuxeo.osgi.SystemBundle;
import org.nuxeo.osgi.SystemBundleFile;
import org.nuxeo.osgi.application.StandaloneBundleLoader;
import org.nuxeo.runtime.RuntimeService;
import org.nuxeo.runtime.RuntimeServiceException;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.Extension;
import org.nuxeo.runtime.model.RuntimeContext;
import org.nuxeo.runtime.model.StreamRef;
import org.nuxeo.runtime.model.URLStreamRef;
import org.nuxeo.runtime.model.impl.DefaultRuntimeContext;
import org.nuxeo.runtime.model.impl.RegistrationInfoImpl;
import org.nuxeo.runtime.osgi.OSGiRuntimeContext;
import org.nuxeo.runtime.osgi.OSGiRuntimeService;
import org.nuxeo.runtime.test.InlineRef;
import org.nuxeo.runtime.test.RootRuntimeBundle;
import org.nuxeo.runtime.test.TargetResourceLocator;
import org.nuxeo.runtime.test.WorkingDirectoryConfigurator;
import org.nuxeo.runtime.test.runner.RuntimeHarness;
import org.nuxeo.runtime.test.runner.TargetExtensions;
import org.nuxeo.runtime.transaction.TransactionHelper;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkEvent;

public class RuntimeHarnessImpl
implements RuntimeHarness {
    protected static final Logger log = LogManager.getLogger(RuntimeHarnessImpl.class);
    protected StandaloneBundleLoader bundleLoader;
    protected Map<String, BundleFile> bundles;
    protected boolean frameworkStarted;
    protected OSGiAdapter osgi;
    protected Set<URI> readUris;
    protected OSGiRuntimeService runtime;
    protected Bundle runtimeBundle;
    protected TargetResourceLocator targetResourceLocator;
    protected URL[] urls;
    protected List<WorkingDirectoryConfigurator> wdConfigs = new ArrayList<WorkingDirectoryConfigurator>();
    protected File workingDir;

    protected static URL[] introspectClasspath() {
        return (URL[])new ClassGraph().getClasspathFiles().stream().map(file -> {
            try {
                return file.toURI().toURL();
            }
            catch (MalformedURLException cause) {
                throw new RuntimeServiceException("Could not get URL from " + file, (Throwable)cause);
            }
        }).toArray(URL[]::new);
    }

    protected RuntimeHarnessImpl() {
    }

    public RuntimeHarnessImpl(Class<?> clazz) {
        this();
        this.targetResourceLocator = new TargetResourceLocator(clazz);
    }

    @Override
    public void addWorkingDirectoryConfigurator(WorkingDirectoryConfigurator config) {
        this.wdConfigs.add(config);
    }

    @Override
    public void deployBundle(String name) throws Exception {
        BundleImpl bundle = this.bundleLoader.getOSGi().getRegistry().getBundle(name);
        if (bundle == null) {
            BundleFile bundleFile = this.lookupBundle(name);
            this.bundleLoader.loadBundle(bundleFile);
            this.bundleLoader.installBundle(bundleFile);
            bundle = this.bundleLoader.getOSGi().getRegistry().getBundle(name);
        } else {
            log.info("A bundle with name {} has been found. Deploy is ignored.", (Object)name);
        }
        if (this.runtime.getContext((Bundle)bundle) == null) {
            this.runtime.createContext((Bundle)bundle);
        }
    }

    @Override
    public void deployContrib(String name, String contrib) throws Exception {
        RuntimeContext context = this.runtime.getContext(name);
        if (context == null) {
            context = this.runtime.getContext();
            BundleFile file = this.lookupBundle(name);
            URL location = file.getEntry(contrib);
            if (location == null) {
                throw new AssertionError((Object)("Cannot locate " + contrib + " in " + name));
            }
            context.deploy(location);
        } else {
            context.deploy(contrib);
        }
    }

    @Override
    @Deprecated
    public void deployFolder(File folder, ClassLoader loader) throws Exception {
        DirectoryBundleFile bf = new DirectoryBundleFile(folder);
        BundleImpl bundle = new BundleImpl(this.osgi, (BundleFile)bf, loader);
        this.osgi.install(bundle);
    }

    @Override
    public RuntimeContext deployPartial(String name, Set<TargetExtensions> targetExtensions) throws Exception {
        BundleImpl bundle = new BundleImpl(this.osgi, this.lookupBundle(name), this.getClass().getClassLoader());
        OSGiRuntimeContext ctx = new OSGiRuntimeContext((RuntimeService)this.runtime, (Bundle)bundle);
        this.listBundleComponents((Bundle)bundle).map(URLStreamRef::new).forEach(arg_0 -> this.lambda$deployPartial$2((RuntimeContext)ctx, targetExtensions, name, arg_0));
        return ctx;
    }

    @Override
    @Deprecated
    public RuntimeContext deployTestContrib(String bundle, String contrib) throws Exception {
        URL url = this.targetResourceLocator.getTargetTestResource(contrib);
        return this.deployTestContrib(bundle, url);
    }

    @Override
    @Deprecated
    public RuntimeContext deployTestContrib(String bundle, URL contrib) throws Exception {
        BundleImpl b = this.bundleLoader.getOSGi().getRegistry().getBundle(bundle);
        if (b == null) {
            b = this.osgi.getSystemBundle();
        }
        OSGiRuntimeContext ctx = new OSGiRuntimeContext((RuntimeService)this.runtime, (Bundle)b);
        ctx.deploy(contrib);
        return ctx;
    }

    @Override
    public void fireFrameworkStarted() {
        if (this.frameworkStarted) {
            throw new IllegalStateException("fireFrameworkStarted must not be called more than once");
        }
        this.frameworkStarted = true;
        boolean txStarted = !TransactionHelper.isTransactionActiveOrMarkedRollback() && TransactionHelper.startTransaction();
        boolean txFinished = false;
        try {
            this.osgi.fireFrameworkEvent(new FrameworkEvent(1, this.runtimeBundle, null));
            txFinished = true;
        }
        finally {
            if (!txFinished) {
                TransactionHelper.setTransactionRollbackOnly();
            }
            if (txStarted) {
                TransactionHelper.commitOrRollbackTransaction();
            }
        }
    }

    @Override
    @Deprecated
    public List<String> getClassLoaderFiles() throws URISyntaxException {
        ArrayList<String> files = new ArrayList<String>(this.urls.length);
        for (URL url : this.urls) {
            files.add(url.toURI().getPath());
        }
        return files;
    }

    @Override
    public RuntimeContext getContext() {
        return this.runtime.getContext();
    }

    @Override
    public OSGiAdapter getOSGiAdapter() {
        return this.osgi;
    }

    @Override
    @Deprecated
    public Properties getProperties() {
        return this.runtime.getProperties();
    }

    @Override
    public File getWorkingDir() {
        return this.workingDir;
    }

    @Override
    public boolean isRestart() {
        return false;
    }

    @Override
    public boolean isStarted() {
        return this.runtime != null;
    }

    @Override
    public void restart() throws Exception {
    }

    @Override
    public void start() throws Exception {
        System.setProperty("org.nuxeo.runtime.testing", "true");
        this.wipeEmptyTestSystemProperties();
        this.wipeRuntime();
        this.initUrls();
        if (this.urls == null) {
            throw new UnsupportedOperationException("no bundles available");
        }
        this.initOsgiRuntime();
    }

    @Override
    public void stop() throws Exception {
        this.wipeRuntime();
        if (this.workingDir != null) {
            if (this.workingDir.exists() && !FileUtils.deleteQuietly((File)this.workingDir)) {
                log.warn("Cannot delete {}", (Object)this.workingDir);
            }
            this.workingDir = null;
        }
        this.readUris = null;
        this.bundles = null;
    }

    @Override
    public void undeployContrib(String name, String contrib) {
        RuntimeContext context = this.runtime.getContext(name);
        if (context == null) {
            context = this.runtime.getContext();
        }
        context.undeploy(contrib);
    }

    protected void deployPartialComponent(RuntimeContext ctx, Set<TargetExtensions> extensionPoints, StreamRef component) throws IOException {
        RegistrationInfoImpl ri = ((DefaultRuntimeContext)ctx).createRegistrationInfo(component);
        String name = ri.getName().getName() + "-partial";
        Set targets = extensionPoints.stream().map(TargetExtensions::getTargetExtensions).flatMap(Collection::stream).collect(Collectors.toSet());
        String ext = Arrays.stream(ri.getExtensions()).filter(e -> targets.contains(TargetExtensions.newTargetExtension(e.getTargetComponent().getName(), e.getExtensionPoint()))).map(Extension::toXML).collect(Collectors.joining());
        ctx.deploy((StreamRef)new InlineRef(name, String.format("<component name=\"%s\">%s</component>", name, ext)));
    }

    protected void initOsgiRuntime() throws Exception {
        try {
            Environment.setDefault(null);
            if (System.getProperties().remove("nuxeo.home") != null) {
                log.warn("Removed System property nuxeo.home.");
            }
            this.workingDir = File.createTempFile("nxruntime-" + Thread.currentThread().getName() + "-", null, new File("target"));
            Files.delete(this.workingDir.toPath());
        }
        catch (IOException e) {
            log.error("Could not init working directory", (Throwable)e);
            throw e;
        }
        this.osgi = new OSGiAdapter(this.workingDir);
        SystemBundleFile bf = new SystemBundleFile(this.workingDir);
        this.bundleLoader = new StandaloneBundleLoader(this.osgi, RuntimeHarnessImpl.class.getClassLoader());
        SystemBundle systemBundle = new SystemBundle(this.osgi, (BundleFile)bf, this.bundleLoader.getSharedClassLoader().getLoader());
        this.osgi.setSystemBundle(systemBundle);
        Thread.currentThread().setContextClassLoader(this.bundleLoader.getSharedClassLoader().getLoader());
        for (WorkingDirectoryConfigurator cfg : this.wdConfigs) {
            cfg.configure(this, this.workingDir);
        }
        this.bundleLoader.setScanForNestedJARs(false);
        this.bundleLoader.setExtractNestedJARs(false);
        BundleFile bundleFile = this.lookupBundle("org.nuxeo.runtime");
        this.runtimeBundle = new RootRuntimeBundle(this.osgi, bundleFile, this.bundleLoader.getClass().getClassLoader(), true);
        this.runtimeBundle.start();
        this.runtime = (OSGiRuntimeService)Framework.getRuntime();
    }

    protected void initUrls() {
        this.urls = RuntimeHarnessImpl.introspectClasspath();
        log.debug("URLs on the classpath:\n{}", new Supplier[]{() -> Stream.of(this.urls).map(URL::toString).collect(Collectors.joining("\n"))});
        this.readUris = new HashSet<URI>();
        this.bundles = new HashMap<String, BundleFile>();
    }

    protected Stream<URL> listBundleComponents(Bundle bundle) {
        String list = OSGiRuntimeService.getComponentsList((Bundle)bundle);
        String name = bundle.getSymbolicName();
        log.debug("PartialBundle: {} components: {}", (Object)name, (Object)list);
        if (list == null) {
            return Stream.empty();
        }
        return Arrays.stream(list.split("[, \t\n\r\f]")).map(arg_0 -> ((Bundle)bundle).getEntry(arg_0)).filter(Objects::nonNull);
    }

    protected BundleFile lookupBundle(String bundleName) throws Exception {
        Object bundleFile = this.bundles.get(bundleName);
        if (bundleFile != null) {
            return bundleFile;
        }
        for (URL url : this.urls) {
            URI uri = url.toURI();
            if (this.readUris.contains(uri)) continue;
            File file = new File(uri);
            this.readUris.add(uri);
            try {
                bundleFile = file.isDirectory() ? new DirectoryBundleFile(file) : new JarBundleFile(file);
            }
            catch (IOException e) {
                continue;
            }
            String symbolicName = this.readSymbolicName((BundleFile)bundleFile);
            if (symbolicName != null) {
                log.debug("Bundle '{}' has URL {}", (Object)symbolicName, (Object)url);
                this.bundles.put(symbolicName, (BundleFile)bundleFile);
            }
            if (!bundleName.equals(symbolicName)) continue;
            return bundleFile;
        }
        throw new RuntimeServiceException(String.format("No bundle with symbolic name '%s';", bundleName));
    }

    protected String readSymbolicName(BundleFile bf) {
        Manifest manifest = bf.getManifest();
        if (manifest == null) {
            return null;
        }
        Attributes attrs = manifest.getMainAttributes();
        String name = attrs.getValue("Bundle-SymbolicName");
        if (name == null) {
            return null;
        }
        String[] sp = name.split(";", 2);
        return sp[0];
    }

    protected void wipeRuntime() {
        this.runtime = null;
        this.frameworkStarted = false;
        if (Framework.getRuntime() != null) {
            try {
                Framework.shutdown();
            }
            catch (InterruptedException cause) {
                Thread.currentThread().interrupt();
                throw new RuntimeServiceException("Interrupted during shutdown", (Throwable)cause);
            }
        }
    }

    protected void wipeEmptyTestSystemProperties() {
        List<String> emptyProps = System.getProperties().entrySet().stream().filter(this::isAnEmptyTestProperty).map(entry -> entry.getKey().toString()).collect(Collectors.toList());
        emptyProps.forEach(System::clearProperty);
        if (log.isDebugEnabled()) {
            emptyProps.forEach(property -> log.debug("Removed empty test system property: {}", property));
        }
    }

    protected boolean isAnEmptyTestProperty(Map.Entry<Object, Object> entry) {
        if (!entry.getKey().toString().startsWith("nuxeo.test.")) {
            return false;
        }
        return entry.getValue() == null || entry.getValue().toString().isEmpty();
    }

    private /* synthetic */ void lambda$deployPartial$2(RuntimeContext ctx, Set targetExtensions, String name, URLStreamRef component) {
        try {
            this.deployPartialComponent(ctx, targetExtensions, (StreamRef)component);
        }
        catch (IOException e) {
            log.error("PartialBundle: {} failed to load: {}", (Object)name, (Object)component, (Object)e);
        }
    }
}

