/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.test.runner;

import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Logger;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.ConsoleAppender;
import org.apache.logging.log4j.core.config.Configurator;
import org.apache.logging.log4j.core.filter.ThresholdFilter;
import org.junit.runners.model.FrameworkMethod;
import org.nuxeo.runtime.test.runner.ConsoleLogLevelThreshold;
import org.nuxeo.runtime.test.runner.FeaturesRunner;
import org.nuxeo.runtime.test.runner.LoggerLevel;
import org.nuxeo.runtime.test.runner.LoggerLevelKey;
import org.nuxeo.runtime.test.runner.LoggerLevels;
import org.nuxeo.runtime.test.runner.RunnerFeature;

public class LogFeature
implements RunnerFeature {
    protected static final String CONSOLE_APPENDER = "CONSOLE";
    protected static final String CONSOLE_LOG_FEATURE_APPENDER = "CONSOLE_LOG_FEATURE";
    protected ConsoleAppender consoleAppender;
    protected ConsoleAppender hiddenAppender;
    protected Map<LoggerLevelKey, Level> originalLevelByLogger = new ConcurrentHashMap<LoggerLevelKey, Level>();

    @Override
    public void beforeRun(FeaturesRunner runner) {
        this.originalLevelByLogger.clear();
        this.addOrUpdateLoggerLevel(runner, null);
        this.addConsoleThresholdLogLevel(runner, null);
    }

    @Override
    public void afterRun(FeaturesRunner runner) {
        this.restoreLoggerLevel(runner, null);
        this.restoreConsoleThresholdLogLevel(runner, null);
    }

    @Override
    public void beforeMethodRun(FeaturesRunner runner, FrameworkMethod method, Object test) {
        this.addOrUpdateLoggerLevel(runner, method);
        this.addConsoleThresholdLogLevel(runner, method);
    }

    @Override
    public void afterMethodRun(FeaturesRunner runner, FrameworkMethod method, Object test) {
        this.restoreLoggerLevel(runner, method);
        this.restoreConsoleThresholdLogLevel(runner, method);
    }

    @Deprecated(since="11.1", forRemoval=true)
    public void hideWarningFromConsoleLog() {
        this.setConsoleLogThreshold(Level.ERROR.toString());
    }

    @Deprecated(since="11.1", forRemoval=true)
    public void hideErrorFromConsoleLog() {
        this.setConsoleLogThreshold(Level.FATAL.toString());
    }

    public void setConsoleLogThreshold(String level) {
        if (this.consoleAppender != null) {
            return;
        }
        Logger rootLogger = LoggerContext.getContext((boolean)false).getRootLogger();
        this.consoleAppender = (ConsoleAppender)rootLogger.getAppenders().get(CONSOLE_APPENDER);
        rootLogger.removeAppender((Appender)this.consoleAppender);
        ConsoleAppender newAppender = ((ConsoleAppender.Builder)((ConsoleAppender.Builder)ConsoleAppender.newBuilder().withName(CONSOLE_LOG_FEATURE_APPENDER)).setTarget(ConsoleAppender.Target.SYSTEM_OUT).withFilter((Filter)ThresholdFilter.createFilter((Level)Level.toLevel((String)level), null, null))).build();
        newAppender.start();
        rootLogger.addAppender((Appender)newAppender);
        this.hiddenAppender = newAppender;
    }

    public void restoreConsoleLog() {
        if (this.consoleAppender == null) {
            return;
        }
        Logger rootLogger = LoggerContext.getContext((boolean)false).getRootLogger();
        rootLogger.removeAppender((Appender)this.hiddenAppender);
        rootLogger.addAppender((Appender)this.consoleAppender);
        this.consoleAppender = null;
        this.hiddenAppender = null;
    }

    protected void addConsoleThresholdLogLevel(FeaturesRunner runner, FrameworkMethod method) {
        this.restoreConsoleLog();
        ConsoleLogLevelThreshold consoleLogThreshold = this.getAnnotation(runner, method, ConsoleLogLevelThreshold.class);
        if (consoleLogThreshold.value() != null) {
            this.setConsoleLogThreshold(consoleLogThreshold.value());
        }
    }

    protected void restoreConsoleThresholdLogLevel(FeaturesRunner runner, FrameworkMethod method) {
        ConsoleLogLevelThreshold consoleLogThreshold = this.getAnnotation(runner, method, ConsoleLogLevelThreshold.class);
        if (consoleLogThreshold.value() != null) {
            this.restoreConsoleLog();
        }
    }

    protected void addOrUpdateLoggerLevel(FeaturesRunner runner, FrameworkMethod method) {
        for (LoggerLevel logger : this.getLoggers(runner, method)) {
            if (logger.level() == null) continue;
            String loggerName = this.getLoggerName(logger);
            LoggerContext context = LoggerContext.getContext((boolean)false);
            if (!context.hasLogger(loggerName)) {
                Configurator.setLevel((String)loggerName, (Level)Level.OFF);
            }
            this.originalLevelByLogger.put(this.buildKey(logger, method), context.getLogger(loggerName).getLevel());
            Configurator.setLevel((String)loggerName, (Level)Level.toLevel((String)logger.level()));
        }
    }

    protected void restoreLoggerLevel(FeaturesRunner runner, FrameworkMethod method) {
        for (LoggerLevel logger : this.getLoggers(runner, method)) {
            if (logger.level() == null) continue;
            String loggerName = this.getLoggerName(logger);
            Level level = this.originalLevelByLogger.remove(this.buildKey(logger, method));
            Configurator.setLevel((String)loggerName, (Level)level);
        }
    }

    protected List<LoggerLevel> getLoggers(FeaturesRunner runner, FrameworkMethod method) {
        ArrayList<LoggerLevel> loggers = new ArrayList<LoggerLevel>(List.of(this.getAnnotation(runner, method, LoggerLevel.class)));
        LoggerLevels configs = this.getAnnotation(runner, method, LoggerLevels.class);
        if (configs.value() != null) {
            loggers.addAll(List.of(configs.value()));
        }
        return loggers;
    }

    protected <T extends Annotation> T getAnnotation(FeaturesRunner runner, FrameworkMethod method, Class<T> type) {
        return method != null ? runner.getConfig(method, type) : runner.getConfig(type);
    }

    protected String getLoggerName(LoggerLevel logLevel) {
        return (String)StringUtils.defaultIfBlank((CharSequence)logLevel.name(), (CharSequence)logLevel.klass().getName());
    }

    protected LoggerLevelKey buildKey(LoggerLevel logger, FrameworkMethod method) {
        ElementType type = method != null ? ElementType.METHOD : ElementType.TYPE;
        String loggerName = this.getLoggerName(logger);
        return new LoggerLevelKey(type, loggerName);
    }
}

