/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.api.login;

import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.nuxeo.runtime.api.login.CredentialsCallback;

public class CredentialsCallbackHandler
implements CallbackHandler {
    private final String name;
    private final Object credentials;

    public CredentialsCallbackHandler(String username, Object credentials) {
        this.name = username;
        this.credentials = credentials;
    }

    @Override
    public void handle(Callback[] callbacks) throws UnsupportedCallbackException {
        for (Callback cb : callbacks) {
            if (cb instanceof NameCallback) {
                ((NameCallback)cb).setName(this.name);
                continue;
            }
            if (cb instanceof PasswordCallback) {
                if (this.credentials instanceof CharSequence) {
                    ((PasswordCallback)cb).setPassword(this.credentials.toString().toCharArray());
                    continue;
                }
                if (this.credentials instanceof char[]) {
                    ((PasswordCallback)cb).setPassword((char[])this.credentials);
                    continue;
                }
                ((PasswordCallback)cb).setPassword(null);
                continue;
            }
            if (cb instanceof CredentialsCallback) {
                ((CredentialsCallback)cb).setCredentials(this.credentials);
                continue;
            }
            throw new UnsupportedCallbackException(cb, "Unsupported callback " + cb + ". Only NameCallback, PasswordCallback and CredentialsCallback are supported by this handler.");
        }
    }
}

