/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime;

import java.io.Serializable;
import org.nuxeo.runtime.model.RegistrationInfo;

public class ComponentEvent
implements Serializable {
    public static final int COMPONENT_REGISTERED = 1;
    public static final int ACTIVATING_COMPONENT = 2;
    public static final int DEACTIVATING_COMPONENT = 3;
    public static final int COMPONENT_ACTIVATED = 4;
    public static final int COMPONENT_DEACTIVATED = 5;
    public static final int COMPONENT_UNREGISTERED = 6;
    public static final int COMPONENT_RESOLVED = 7;
    public static final int COMPONENT_UNRESOLVED = 8;
    public static final int EXTENSION_REGISTERED = 9;
    public static final int EXTENSION_UNREGISTERED = 10;
    public static final int EXTENSION_PENDING = 11;
    public static final int STARTING_COMPONENT = 12;
    public static final int STOPPING_COMPONENT = 13;
    public static final int COMPONENT_STARTED = 14;
    public static final int COMPONENT_STOPPED = 15;
    public static final int COMPONENT_EVENT = 100;
    private static final long serialVersionUID = 8936615866437064000L;
    public final int id;
    public final RegistrationInfo registrationInfo;
    public final Serializable data;

    public ComponentEvent(int id, RegistrationInfo ri) {
        this(id, ri, null);
    }

    public ComponentEvent(int id, RegistrationInfo ri, Serializable data) {
        this.id = id;
        this.registrationInfo = ri;
        this.data = data;
    }

    public final String getEventName() {
        switch (this.id) {
            case 1: {
                return "COMPONENT_REGISTERED";
            }
            case 7: {
                return "COMPONENT_RESOLVED";
            }
            case 8: {
                return "COMPONENT_UNRESOLVED";
            }
            case 2: {
                return "ACTIVATING_COMPONENT";
            }
            case 3: {
                return "DEACTIVATING_COMPONENT";
            }
            case 4: {
                return "COMPONENT_ACTIVATED";
            }
            case 5: {
                return "COMPONENT_DEACTIVATED";
            }
            case 6: {
                return "COMPONENT_UNREGISTERED";
            }
            case 12: {
                return "STARTING_COMPONENT";
            }
            case 13: {
                return "STOPPING_COMPONENT";
            }
            case 14: {
                return "COMPONENT_STARTED";
            }
            case 15: {
                return "COMPONENT_STOPPED";
            }
            case 100: {
                return "COMPONENT_EVENT";
            }
            case 9: {
                return "EXTENSION_REGISTERED";
            }
            case 11: {
                return "EXTENSION_PENDING";
            }
        }
        return "UNKNOWN_" + this.id;
    }

    public String toString() {
        return this.getEventName() + ": " + this.registrationInfo.getName();
    }
}

