/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.model.impl;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuxeo.common.xmap.annotation.XContent;
import org.nuxeo.common.xmap.annotation.XNode;
import org.nuxeo.common.xmap.annotation.XNodeList;
import org.nuxeo.common.xmap.annotation.XNodeMap;
import org.nuxeo.common.xmap.annotation.XObject;
import org.nuxeo.runtime.ComponentEvent;
import org.nuxeo.runtime.Version;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.Component;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.ComponentManager;
import org.nuxeo.runtime.model.ComponentName;
import org.nuxeo.runtime.model.ConfigurationDescriptor;
import org.nuxeo.runtime.model.Extension;
import org.nuxeo.runtime.model.ExtensionPoint;
import org.nuxeo.runtime.model.Property;
import org.nuxeo.runtime.model.RegistrationInfo;
import org.nuxeo.runtime.model.RuntimeContext;
import org.nuxeo.runtime.model.impl.ComponentInstanceImpl;
import org.nuxeo.runtime.model.impl.ComponentManagerImpl;
import org.nuxeo.runtime.model.impl.ExtensionImpl;
import org.nuxeo.runtime.model.impl.ExtensionPointImpl;
import org.nuxeo.runtime.model.impl.ServiceDescriptor;

@XObject(value="component")
public class RegistrationInfoImpl
implements RegistrationInfo {
    private static final long serialVersionUID = -4135715215018199522L;
    private static final Logger log = LogManager.getLogger(ComponentManager.class);
    transient ComponentManagerImpl manager;
    @XNode(value="@service")
    ServiceDescriptor serviceDescriptor;
    @XNode(value="@name")
    ComponentName name;
    @XNode(value="@disabled")
    boolean disabled;
    @XNode(value="configuration")
    ConfigurationDescriptor config;
    int state = 0;
    @XNodeList(value="alias", type=HashSet.class, componentType=ComponentName.class)
    Set<ComponentName> aliases = new HashSet<ComponentName>();
    @XNodeList(value="require", type=HashSet.class, componentType=ComponentName.class)
    Set<ComponentName> requires = new HashSet<ComponentName>();
    @XNode(value="implementation@class")
    String implementation;
    @XNodeList(value="extension-point", type=ExtensionPointImpl[].class, componentType=ExtensionPointImpl.class)
    ExtensionPointImpl[] extensionPoints = new ExtensionPointImpl[0];
    @XNodeList(value="extension", type=ExtensionImpl[].class, componentType=ExtensionImpl.class)
    ExtensionImpl[] extensions = new ExtensionImpl[0];
    @XNodeMap(value="property", key="@name", type=HashMap.class, componentType=Property.class)
    Map<String, Property> properties = new HashMap<String, Property>();
    @XNode(value="@version")
    Version version = Version.ZERO;
    @XNode(value="@bundle")
    String bundle;
    @XContent(value="documentation")
    String documentation;
    URL xmlFileUrl;
    String sourceId;
    boolean isPersistent;
    transient RuntimeContext context;
    transient ComponentInstance component;

    public RegistrationInfoImpl() {
    }

    public RegistrationInfoImpl(ComponentName name) {
        this.name = name;
    }

    public void attach(ComponentManagerImpl manager) {
        if (this.manager != null) {
            throw new IllegalStateException("Registration '" + this.name + "' was already attached to a manager");
        }
        this.manager = manager;
    }

    public void setContext(RuntimeContext context) {
        this.context = context;
    }

    @Override
    public boolean isDisabled() {
        return this.disabled;
    }

    @Override
    public final boolean isPersistent() {
        return this.isPersistent;
    }

    @Override
    public void setPersistent(boolean isPersistent) {
        this.isPersistent = isPersistent;
    }

    public void destroy() {
        this.requires.clear();
        this.aliases.clear();
        this.properties.clear();
        this.extensionPoints = new ExtensionPointImpl[0];
        this.extensions = new ExtensionImpl[0];
        this.version = null;
        this.component = null;
        this.name = null;
        this.manager = null;
    }

    public final boolean isDisposed() {
        return this.name == null;
    }

    @Override
    public ExtensionPoint[] getExtensionPoints() {
        return this.extensionPoints;
    }

    @Override
    public ComponentInstance getComponent() {
        return this.component;
    }

    @Deprecated
    public synchronized void reload() {
        if (this.component != null) {
            this.component.reload();
        }
    }

    @Override
    public ComponentName getName() {
        return this.name;
    }

    @Override
    public Map<String, Property> getProperties() {
        return this.properties;
    }

    @Override
    public int getState() {
        return this.state;
    }

    @Override
    public Extension[] getExtensions() {
        if (!this.useFormerLifecycleManagement()) {
            this.checkExtensions();
        }
        return this.extensions;
    }

    @Override
    public Set<ComponentName> getAliases() {
        return this.aliases == null ? Collections.emptySet() : this.aliases;
    }

    @Override
    public Set<ComponentName> getRequiredComponents() {
        return this.requires;
    }

    @Override
    public RuntimeContext getContext() {
        return this.context;
    }

    @Override
    public String getBundle() {
        return this.bundle;
    }

    @Override
    public Version getVersion() {
        return this.version;
    }

    @Override
    public String getDocumentation() {
        return this.documentation;
    }

    public String toString() {
        return "RegistrationInfo: " + this.name;
    }

    @Override
    public ComponentManager getManager() {
        return this.manager;
    }

    synchronized void register() {
        if (this.state != 0) {
            return;
        }
        this.state = 1;
        this.manager.sendEvent(new ComponentEvent(1, this));
    }

    synchronized void unregister() {
        if (this.state == 0) {
            return;
        }
        if (this.state == 5 || this.state == 2 || this.state == 6) {
            this.unresolve();
        }
        this.state = 0;
        this.manager.sendEvent(new ComponentEvent(6, this));
        this.destroy();
    }

    @Override
    public void setState(int state) {
        this.state = state;
        int componentEvent = -1;
        switch (state) {
            case 0: {
                componentEvent = 6;
                break;
            }
            case 1: {
                componentEvent = 1;
                break;
            }
            case 2: {
                componentEvent = 7;
                break;
            }
            case 3: {
                componentEvent = 2;
                break;
            }
            case 5: {
                componentEvent = 2;
                break;
            }
            case 8: {
                componentEvent = 12;
                break;
            }
            case 7: {
                componentEvent = 14;
                break;
            }
            case 6: {
                break;
            }
            case 9: {
                componentEvent = 13;
                break;
            }
            case 4: {
                componentEvent = 3;
            }
        }
        if (componentEvent > -1) {
            this.manager.sendEvent(new ComponentEvent(componentEvent, this));
        }
    }

    protected ComponentInstance createComponentInstance() {
        try {
            return new ComponentInstanceImpl(this);
        }
        catch (RuntimeException e) {
            String msg = "Failed to instantiate component: " + this.implementation;
            log.error(msg, (Throwable)e);
            msg = msg + " (" + e.toString() + ")";
            Framework.getRuntime().getMessageHandler().addError(msg);
            throw e;
        }
    }

    @Deprecated
    public synchronized void restart() {
        this.deactivate();
        this.activate();
    }

    @Override
    public int getApplicationStartedOrder() {
        if (this.component == null) {
            return 0;
        }
        Object ci = this.component.getInstance();
        if (!(ci instanceof Component)) {
            return 0;
        }
        return ((Component)ci).getApplicationStartedOrder();
    }

    public synchronized void start() {
        if (this.state != 5) {
            return;
        }
        this.state = 8;
        this.manager.sendEvent(new ComponentEvent(12, this));
        try {
            Object ci;
            if (this.component != null && (ci = this.component.getInstance()) instanceof Component) {
                ((Component)ci).start(this.component);
            }
            log.debug("Component started: {}", (Object)this.name);
            this.state = 7;
            this.manager.sendEvent(new ComponentEvent(14, this));
        }
        catch (RuntimeException e) {
            log.error(String.format("Component %s notification of application started failed: %s", this.component == null ? null : this.component.getName(), e.getMessage()), (Throwable)e);
            this.state = 6;
        }
    }

    @Override
    public boolean isStarted() {
        return this.state == 7;
    }

    public synchronized void stop() throws InterruptedException {
        Object ci;
        if (this.state != 7) {
            return;
        }
        this.state = 9;
        this.manager.sendEvent(new ComponentEvent(13, this));
        if (this.component != null && (ci = this.component.getInstance()) instanceof Component) {
            ((Component)ci).stop(this.component);
        }
        log.debug("Component stopped: {}", (Object)this.name);
        this.state = 5;
        this.manager.sendEvent(new ComponentEvent(15, this));
    }

    public synchronized void activate() {
        if (this.state != 2) {
            return;
        }
        this.component = this.createComponentInstance();
        this.state = 3;
        this.manager.sendEvent(new ComponentEvent(2, this));
        this.component.activate();
        log.debug("Component activated: {}", (Object)this.name);
        this.state = 5;
        this.manager.sendEvent(new ComponentEvent(4, this));
        if (this.extensions != null) {
            this.checkExtensions();
            for (ExtensionImpl xt : this.extensions) {
                xt.setComponent(this.component);
                try {
                    this.manager.registerExtension(xt);
                }
                catch (RuntimeException e) {
                    String msg = "Failed to register extension to: " + xt.getTargetComponent() + ", xpoint: " + xt.getExtensionPoint() + " in component: " + xt.getComponent().getName();
                    log.error(msg, (Throwable)e);
                    msg = msg + " (" + e.toString() + ")";
                    Framework.getRuntime().getMessageHandler().addError(msg);
                }
            }
        }
        ArrayList<ComponentName> names = new ArrayList<ComponentName>(1 + this.aliases.size());
        names.add(this.name);
        names.addAll(this.aliases);
        for (ComponentName n : names) {
            Set pendingExt = (Set)this.manager.pendingExtensions.remove(n);
            if (pendingExt == null) continue;
            for (Extension xt : pendingExt) {
                ComponentManagerImpl.loadContributions(this, xt);
                try {
                    this.component.registerExtension(xt);
                }
                catch (RuntimeException e) {
                    String msg = "Failed to register extension to: " + xt.getTargetComponent() + ", xpoint: " + xt.getExtensionPoint() + " in component: " + xt.getComponent().getName();
                    log.error(msg, (Throwable)e);
                    msg = msg + " (" + e.toString() + ")";
                    Framework.getRuntime().getMessageHandler().addError(msg);
                }
            }
        }
    }

    public synchronized void deactivate() {
        this.deactivate(true);
    }

    public synchronized void deactivate(boolean mustUnregisterExtensions) {
        if (this.state != 5 && this.state != 6) {
            return;
        }
        this.state = 4;
        this.manager.sendEvent(new ComponentEvent(3, this));
        if (mustUnregisterExtensions && this.extensions != null) {
            for (ExtensionImpl xt : this.extensions) {
                try {
                    this.manager.unregisterExtension(xt);
                }
                catch (RuntimeException e) {
                    String message = "Failed to unregister extension. Contributor: " + xt.getComponent() + " to " + xt.getTargetComponent() + "; xpoint: " + xt.getExtensionPoint();
                    log.error(message, (Throwable)e);
                    Framework.getRuntime().getMessageHandler().addError(message);
                }
            }
        }
        this.component.deactivate();
        log.debug("Component deactivated: {}", (Object)this.name);
        this.component = null;
        this.state = 2;
        this.manager.sendEvent(new ComponentEvent(5, this));
    }

    public synchronized void resolve() {
        if (this.state != 1) {
            return;
        }
        this.manager.registerServices(this);
        this.state = 2;
        this.manager.sendEvent(new ComponentEvent(7, this));
    }

    public synchronized void unresolve() {
        if (this.state == 1 || this.state == 0) {
            return;
        }
        this.manager.unregisterServices(this);
        this.state = 1;
        this.manager.sendEvent(new ComponentEvent(8, this));
    }

    @Override
    public boolean isActivated() {
        return this.state == 5;
    }

    @Override
    public boolean isResolved() {
        return this.state == 2;
    }

    @Override
    public String[] getProvidedServiceNames() {
        if (this.serviceDescriptor != null) {
            return this.serviceDescriptor.services;
        }
        return null;
    }

    public ServiceDescriptor getServiceDescriptor() {
        return this.serviceDescriptor;
    }

    @Override
    public String getImplementation() {
        return this.implementation;
    }

    public void checkExtensions() {
        for (ExtensionImpl xt : this.extensions) {
            if (xt.target != null) continue;
            Framework.getRuntime().getMessageHandler().addWarning("Bad extension declaration (no target attribute specified). Component: " + this.getName());
        }
    }

    @Override
    public URL getXmlFileUrl() {
        return this.xmlFileUrl;
    }

    @Override
    public String getSourceId() {
        return this.sourceId;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof RegistrationInfo) {
            return this.name.equals(((RegistrationInfo)obj).getName());
        }
        return false;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    @Override
    public boolean useFormerLifecycleManagement() {
        return true;
    }
}

