/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.template.api;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.nuxeo.template.api.InputType;

public class TemplateInput
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected String name;
    protected String stringValue;
    protected Boolean booleanValue;
    protected Date dateValue;
    protected InputType type = InputType.StringValue;
    protected String source;
    protected String desciption;
    protected boolean readOnly;
    protected boolean autoLoop = false;
    private Map<String, TemplateInput> mapValue;

    public TemplateInput(String name) {
        this.name = name;
        this.stringValue = "";
    }

    public TemplateInput(String name, Object value) {
        this.name = name;
        if (value instanceof String) {
            this.stringValue = (String)value;
            this.type = InputType.StringValue;
        } else if (value instanceof Date) {
            this.dateValue = (Date)value;
            this.type = InputType.DateValue;
        } else if (value instanceof Boolean) {
            this.booleanValue = (Boolean)value;
            this.type = InputType.BooleanValue;
        }
    }

    public TemplateInput getCopy(boolean readOnly) {
        TemplateInput item = new TemplateInput(this.name);
        item.booleanValue = this.booleanValue;
        item.dateValue = this.dateValue;
        item.source = this.source;
        item.desciption = this.desciption;
        item.stringValue = this.stringValue;
        item.mapValue = this.mapValue;
        item.type = this.type;
        item.readOnly = readOnly;
        item.autoLoop = this.autoLoop;
        return item;
    }

    public TemplateInput update(TemplateInput other) {
        this.name = other.name;
        this.type = other.type;
        this.autoLoop = other.autoLoop;
        this.booleanValue = other.booleanValue;
        this.dateValue = other.dateValue;
        this.mapValue = other.mapValue;
        this.desciption = other.desciption;
        this.readOnly = other.readOnly;
        this.source = other.source;
        this.stringValue = other.stringValue;
        return this;
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public String getDesciption() {
        return this.desciption;
    }

    public void setDesciption(String desciption) {
        this.desciption = desciption;
    }

    public String toString() {
        String str = this.name + " (" + this.type + ") : '";
        str = InputType.StringValue.equals((Object)this.type) && this.stringValue != null ? str + this.stringValue : (InputType.DateValue.equals((Object)this.type) && this.dateValue != null ? str + this.dateValue.toString() : (InputType.BooleanValue.equals((Object)this.type) && this.booleanValue != null ? str + this.booleanValue.toString() : ((InputType.MapValue.equals((Object)this.type) || InputType.ListValue.equals((Object)this.type)) && this.mapValue != null ? str + this.mapValue.toString() : str + this.source)));
        return str + "'";
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getStringValue() {
        return this.stringValue;
    }

    public void setStringValue(Object stringValue) {
        this.stringValue = (String)stringValue;
    }

    public Boolean getBooleanValue() {
        if (this.booleanValue == null) {
            return Boolean.FALSE;
        }
        return this.booleanValue;
    }

    public void setBooleanValue(Object booleanValue) {
        this.booleanValue = booleanValue == null ? Boolean.FALSE : (booleanValue instanceof String ? Boolean.valueOf((String)booleanValue) : (Boolean)booleanValue);
    }

    public void setBooleanValue(boolean booleanValue) {
        this.booleanValue = booleanValue;
    }

    public Date getDateValue() {
        if (this.dateValue == null) {
            return new Date();
        }
        return this.dateValue;
    }

    public void setDateValue(Object dateValue) {
        this.dateValue = (Date)dateValue;
    }

    public void setMapValue(Object value) {
        if (value instanceof List) {
            this.mapValue = new LinkedHashMap<String, TemplateInput>();
            for (TemplateInput child : (List)value) {
                this.mapValue.put(child.getName(), child);
            }
        } else if (value instanceof Map) {
            this.mapValue = (Map)value;
        }
    }

    public Map<String, TemplateInput> getMapValue() {
        return this.mapValue;
    }

    public List<TemplateInput> getListValue() {
        return new ArrayList<TemplateInput>(this.mapValue.values());
    }

    public InputType getType() {
        return this.type;
    }

    public String getTypeAsString() {
        if (this.type == null) {
            return "";
        }
        return this.type.toString();
    }

    public void setType(InputType type) {
        this.type = type;
    }

    public void setTypeAsString(String strType) {
        this.type = InputType.getByValue(strType);
    }

    public boolean isSimpleValue() {
        return !this.isSourceValue();
    }

    public boolean isSourceValue() {
        return InputType.PictureProperty == this.type || InputType.DocumentProperty == this.type || InputType.Content == this.type;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public boolean isSet() {
        return this.source != null || this.dateValue != null || this.booleanValue != null || this.stringValue != null && !this.stringValue.isEmpty();
    }

    public boolean isAutoLoop() {
        return this.autoLoop;
    }

    public void setAutoLoop(boolean autoLoop) {
        this.autoLoop = autoLoop;
    }

    public static TemplateInput factory(String name, InputType type, Object value) {
        return TemplateInput.factory(name, type, value, null, false, false);
    }

    public static TemplateInput factory(String name, InputType type, Object value, String description, Boolean isReadonly, Boolean isAutoloop) {
        TemplateInput param = new TemplateInput(name);
        param.setType(type);
        param.setReadOnly(Boolean.TRUE.equals(isReadonly));
        param.setAutoLoop(Boolean.TRUE.equals(isAutoloop));
        param.setDesciption(description);
        switch (type) {
            case StringValue: {
                param.setStringValue(value);
                break;
            }
            case BooleanValue: {
                param.setBooleanValue(value);
                break;
            }
            case DateValue: {
                param.setDateValue(value);
                break;
            }
            case MapValue: 
            case ListValue: {
                param.setMapValue(value);
                break;
            }
            case DocumentProperty: 
            case PictureProperty: 
            case Content: {
                param.setSource((String)value);
            }
        }
        return param;
    }
}

