/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.template.processors.jxls;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.sf.jxls.exception.ParsePropertyException;
import net.sf.jxls.transformer.XLSTransformer;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.jxls.common.Context;
import org.jxls.util.JxlsHelper;
import org.nuxeo.common.utils.FileUtils;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.Blobs;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.platform.mimetype.interfaces.MimetypeRegistry;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.services.config.ConfigurationService;
import org.nuxeo.template.api.TemplateInput;
import org.nuxeo.template.api.adapters.TemplateBasedDocument;
import org.nuxeo.template.context.SimpleContextBuilder;
import org.nuxeo.template.processors.AbstractTemplateProcessor;
import org.nuxeo.template.processors.jxls.JXLSBindingResolver;

public class JXLSTemplateProcessor
extends AbstractTemplateProcessor {
    public static final String TEMPLATE_TYPE = "JXLS";
    public static final String USE_JXLS1_CONFIG_PROP = "org.nuxeo.template.rendering.jxls1";
    protected SimpleContextBuilder contextBuilder = new SimpleContextBuilder();

    protected boolean useJXLS1() {
        return ((ConfigurationService)Framework.getService(ConfigurationService.class)).isBooleanTrue(USE_JXLS1_CONFIG_PROP);
    }

    public Blob renderTemplate(TemplateBasedDocument templateBasedDocument, String templateName) throws IOException {
        Blob sourceTemplateBlob = this.getSourceTemplateBlob(templateBasedDocument, templateName);
        List params = templateBasedDocument.getParams(templateName);
        DocumentModel doc = templateBasedDocument.getAdaptedDoc();
        Map ctx = this.contextBuilder.build(doc, templateName);
        JXLSBindingResolver resolver = new JXLSBindingResolver();
        resolver.resolve(params, ctx, templateBasedDocument);
        File workingDir = this.getWorkingDir();
        File generated = new File(workingDir, "JXLSresult-" + System.currentTimeMillis());
        generated.createNewFile();
        File input = new File(workingDir, "JXLSInput-" + System.currentTimeMillis());
        input.createNewFile();
        sourceTemplateBlob.transferTo(input);
        if (this.useJXLS1()) {
            XLSTransformer transformer = new XLSTransformer();
            this.configureTransformer(transformer);
            try {
                transformer.transformXLS(input.getAbsolutePath(), ctx, generated.getAbsolutePath());
            }
            catch (ParsePropertyException | InvalidFormatException e) {
                throw new NuxeoException(e);
            }
        }
        try (BufferedInputStream is = new BufferedInputStream(new FileInputStream(input));
             BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(generated));){
            JxlsHelper.getInstance().processTemplate((InputStream)is, (OutputStream)os, new Context(ctx));
        }
        catch (IOException | IllegalStateException e) {
            throw new NuxeoException((Throwable)e);
        }
        input.delete();
        Blob newBlob = Blobs.createBlob((File)generated);
        String templateFileName = sourceTemplateBlob.getFilename();
        String targetFileExt = FileUtils.getFileExtension((String)templateFileName);
        Object targetFileName = FileUtils.getFileNameNoExt((String)templateBasedDocument.getAdaptedDoc().getTitle());
        targetFileName = (String)targetFileName + "." + targetFileExt;
        newBlob.setFilename((String)targetFileName);
        MimetypeRegistry mimetypeRegistry = (MimetypeRegistry)Framework.getService(MimetypeRegistry.class);
        newBlob.setMimeType(mimetypeRegistry.getMimetypeFromExtension(targetFileExt));
        Framework.trackFile((File)generated, (Object)newBlob);
        return newBlob;
    }

    protected void configureTransformer(XLSTransformer transformer) {
    }

    public List<TemplateInput> getInitialParametersDefinition(Blob blob) {
        return new ArrayList<TemplateInput>();
    }
}

