/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.theme.styling.service.registries;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nuxeo.runtime.model.ContributionFragmentRegistry;
import org.nuxeo.theme.styling.service.descriptors.PageDescriptor;

public class PageRegistry
extends ContributionFragmentRegistry<PageDescriptor> {
    protected Map<String, PageDescriptor> pageResources = new HashMap<String, PageDescriptor>();

    public String getContributionId(PageDescriptor contrib) {
        return contrib.getName();
    }

    public void contributionUpdated(String id, PageDescriptor contrib, PageDescriptor newOrigContrib) {
        this.pageResources.put(id, contrib);
    }

    public synchronized void removeContribution(PageDescriptor contrib) {
        this.removeContribution(contrib, true);
    }

    public void contributionRemoved(String id, PageDescriptor origContrib) {
        this.pageResources.remove(id);
    }

    public PageDescriptor clone(PageDescriptor orig) {
        if (orig == null) {
            return null;
        }
        return orig.clone();
    }

    public void merge(PageDescriptor src, PageDescriptor dst) {
        dst.merge(src);
    }

    public PageDescriptor getPage(String id) {
        return this.pageResources.get(id);
    }

    @Deprecated
    public PageDescriptor getThemePage(String id) {
        return this.getPage(id);
    }

    public List<PageDescriptor> getPages() {
        ArrayList<PageDescriptor> res = new ArrayList<PageDescriptor>();
        for (PageDescriptor page : this.pageResources.values()) {
            if (page == null) continue;
            res.add(page);
        }
        return res;
    }

    public List<String> getPageNames() {
        return new ArrayList<String>(this.pageResources.keySet());
    }

    @Deprecated
    public List<PageDescriptor> getThemePages() {
        return this.getPages();
    }

    public PageDescriptor getConfigurationApplyingToAll() {
        return this.pageResources.get("*");
    }

    @Deprecated
    public PageDescriptor getConfigurationApplyingToAllThemes() {
        return this.getConfigurationApplyingToAll();
    }
}

