/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.common.xmap;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.nuxeo.common.xmap.Context;

public class Resource {
    private final Context ctx;
    private final String path;
    private final URL url;

    public Resource(Context ctx, String path) {
        this.ctx = ctx;
        this.path = path;
        this.url = ctx.getResource(path);
    }

    public URL toURL() {
        return this.url;
    }

    public URI toURI() throws URISyntaxException {
        return this.url != null ? this.url.toURI() : null;
    }

    public File toFile() throws URISyntaxException {
        return this.url != null ? new File(this.url.toURI()) : null;
    }

    public Context getContext() {
        return this.ctx;
    }

    public String getPath() {
        return this.path;
    }

    public String toString() {
        return "Resource{path=" + this.path + "}";
    }
}

