/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.io.services;

import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuxeo.ecm.automation.io.services.codec.ObjectCodecService;
import org.nuxeo.ecm.webengine.JsonFactoryManager;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.DefaultComponent;

public class IOComponent
extends DefaultComponent {
    private static final Logger log = LogManager.getLogger(IOComponent.class);
    public static final String XP_CODECS = "codecs";
    private JsonFactoryManager jsonFactoryManager;
    private ObjectCodecService codecs;

    public <T> T getAdapter(Class<T> adapter) {
        if (ObjectCodecService.class.isAssignableFrom(adapter)) {
            return adapter.cast(this.codecs);
        }
        if (JsonFactoryManager.class.isAssignableFrom(adapter)) {
            return adapter.cast(this.jsonFactoryManager);
        }
        return (T)super.getAdapter(adapter);
    }

    public void start(ComponentContext context) {
        super.start(context);
        this.jsonFactoryManager = (JsonFactoryManager)Framework.getService(JsonFactoryManager.class);
        this.codecs = new ObjectCodecService(this.jsonFactoryManager.getJsonFactory());
        List descriptors = this.getDescriptors(XP_CODECS);
        descriptors.forEach(d -> {
            try {
                this.codecs.addCodec(d.klass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
            }
            catch (ReflectiveOperationException e) {
                log.error("Unable to instantiate codec", (Throwable)e);
            }
        });
        this.codecs.postInit();
    }

    public void stop(ComponentContext context) throws InterruptedException {
        super.stop(context);
        this.codecs = null;
    }
}

