/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.functionaltests;

import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.rules.MethodRule;
import org.nuxeo.functionaltests.AjaxRequestManager;
import org.nuxeo.functionaltests.JavaScriptErrorCollector;
import org.nuxeo.functionaltests.Locator;
import org.nuxeo.functionaltests.LogTestWatchman;
import org.nuxeo.functionaltests.Required;
import org.nuxeo.functionaltests.VariableElementLocatorFactory;
import org.nuxeo.functionaltests.WaitForJQueryAjaxOnLoading;
import org.nuxeo.functionaltests.drivers.ChromeDriverProvider;
import org.nuxeo.functionaltests.drivers.FirefoxDriverProvider;
import org.nuxeo.functionaltests.drivers.RemoteFirefoxDriverProvider;
import org.nuxeo.functionaltests.fragment.WebFragment;
import org.nuxeo.functionaltests.pages.AbstractPage;
import org.nuxeo.functionaltests.pages.DocumentBasePage;
import org.nuxeo.functionaltests.pages.FileDocumentBasePage;
import org.nuxeo.functionaltests.pages.LoginPage;
import org.nuxeo.functionaltests.pages.NoteDocumentBasePage;
import org.nuxeo.functionaltests.pages.tabs.CollectionContentTabSubPage;
import org.nuxeo.functionaltests.proxy.ProxyManager;
import org.nuxeo.runtime.api.Framework;
import org.openqa.selenium.By;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.NoSuchWindowException;
import org.openqa.selenium.NotFoundException;
import org.openqa.selenium.Proxy;
import org.openqa.selenium.TimeoutException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.internal.WrapsElement;
import org.openqa.selenium.remote.Command;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.openqa.selenium.support.PageFactory;
import org.openqa.selenium.support.pagefactory.ElementLocatorFactory;
import org.openqa.selenium.support.ui.FluentWait;

public abstract class AbstractTest {
    public static final String TEST_USERNAME = "jdoe";
    public static final String TEST_PASSWORD = "test";
    public static final int POLLING_FREQUENCY_MILLISECONDS = 100;
    public static final int POLLING_FREQUENCY_SECONDS = 1;
    public static final int PAGE_LOAD_TIME_OUT_SECONDS = 60;
    public static final int LOAD_TIMEOUT_SECONDS = 30;
    public static final int IMPLICIT_WAIT_MILLISECONDS = 200;
    public static final int LOAD_SHORT_TIMEOUT_SECONDS = 2;
    public static final int AJAX_TIMEOUT_SECONDS = 10;
    public static final int AJAX_SHORT_TIMEOUT_SECONDS = 2;
    @Deprecated
    public static final String CHROME_DRIVER_DEFAULT_PATH_LINUX = "/usr/bin/chromedriver";
    @Deprecated
    public static final String CHROME_DRIVER_DEFAULT_PATH_MAC = "/Applications/chromedriver";
    @Deprecated
    public static final String CHROME_DRIVER_DEFAULT_PATH_WINVISTA = ChromeDriverProvider.CHROME_DRIVER_DEFAULT_PATH_WINVISTA;
    @Deprecated
    public static final String CHROME_DRIVER_DEFAULT_PATH_WINXP = ChromeDriverProvider.CHROME_DRIVER_DEFAULT_PATH_WINXP;
    @Deprecated
    public static final String CHROME_DRIVER_DEFAULT_EXECUTABLE_NAME = "chromedriver";
    @Deprecated
    public static final String CHROME_DRIVER_WINDOWS_EXECUTABLE_NAME = "chromedriver.exe";
    @Deprecated
    public static final String SYSPROP_CHROME_DRIVER_PATH = "webdriver.chrome.driver";
    static final Log log = LogFactory.getLog(AbstractTest.class);
    public static final String NUXEO_URL = System.getProperty("nuxeoURL", "http://localhost:8080/nuxeo").replaceAll("/$", "");
    public static RemoteWebDriver driver;
    protected static ProxyManager proxyManager;
    @Rule
    public MethodRule watchman = new LogTestWatchman(driver, NUXEO_URL);
    protected JavaScriptErrorCollector.JavaScriptErrorIgnoreRule[] ignores = new JavaScriptErrorCollector.JavaScriptErrorIgnoreRule[0];

    public void runBeforeAfters() {
        ((LogTestWatchman)this.watchman).runBeforeAfters();
    }

    @BeforeClass
    public static void initDriver() throws Exception {
        String browser = System.getProperty("browser", "firefox");
        if (browser.equals("chrome") || browser.equals("firefox")) {
            AbstractTest.initFirefoxDriver();
        } else if (browser.equals("remotefirefox")) {
            AbstractTest.initRemoteFirefoxDriver();
        } else if (browser.equals("googlechrome")) {
            AbstractTest.initChromeDriver();
        } else {
            throw new RuntimeException("Browser not supported: " + browser);
        }
        driver.manage().timeouts().pageLoadTimeout(60L, TimeUnit.SECONDS);
        driver.manage().timeouts().implicitlyWait(200L, TimeUnit.MILLISECONDS);
    }

    protected static void initFirefoxDriver() throws Exception {
        proxyManager = new ProxyManager();
        Proxy proxy = proxyManager.startProxy();
        if (proxy != null) {
            proxy.setNoProxy("");
        }
        DesiredCapabilities dc = DesiredCapabilities.firefox();
        dc.setCapability("proxy", (Object)proxy);
        driver = new FirefoxDriverProvider().init(dc);
    }

    protected static void initRemoteFirefoxDriver() throws Exception {
        proxyManager = new ProxyManager();
        Proxy proxy = proxyManager.startProxy();
        if (proxy != null) {
            proxy.setNoProxy("");
        }
        DesiredCapabilities dc = DesiredCapabilities.firefox();
        dc.setCapability("proxy", (Object)proxy);
        driver = new RemoteFirefoxDriverProvider().init(dc);
    }

    protected static void initChromeDriver() throws Exception {
        proxyManager = new ProxyManager();
        Proxy proxy = proxyManager.startProxy();
        DesiredCapabilities dc = DesiredCapabilities.chrome();
        if (proxy != null) {
            proxy.setNoProxy("");
            dc.setCapability("proxy", (Object)proxy);
        }
        driver = new ChromeDriverProvider().init(dc);
    }

    public void addAfterTestIgnores(JavaScriptErrorCollector.JavaScriptErrorIgnoreRule ... ignores) {
        this.ignores = (JavaScriptErrorCollector.JavaScriptErrorIgnoreRule[])ArrayUtils.addAll((Object[])this.ignores, (Object[])ignores);
    }

    @After
    public void checkJavascriptError() {
        JavaScriptErrorCollector.from((WebDriver)driver).ignore(this.ignores).checkForErrors();
    }

    @AfterClass
    public static void quitDriver() {
        if (driver != null) {
            driver.quit();
            driver = null;
        }
        try {
            proxyManager.stopProxy();
            proxyManager = null;
        }
        catch (Exception e) {
            log.error((Object)("Could not stop proxy: " + e.getMessage()));
        }
    }

    public static <T> T get(String url, Class<T> pageClassToProxy, JavaScriptErrorCollector.JavaScriptErrorIgnoreRule ... ignores) {
        JavaScriptErrorCollector.from((WebDriver)driver).ignore(ignores).checkForErrors();
        driver.get(url);
        return AbstractTest.asPage(pageClassToProxy);
    }

    public static void open(String url, JavaScriptErrorCollector.JavaScriptErrorIgnoreRule ... ignores) {
        JavaScriptErrorCollector.from((WebDriver)driver).ignore(ignores).checkForErrors();
        driver.get(NUXEO_URL + url + "?conversationId=0NXMAIN");
    }

    public static <T> T getWithoutErrorHandler(String url, Class<T> pageClassToProxy) throws IOException {
        Command command = new Command(driver.getSessionId(), "get", (Map)ImmutableMap.of((Object)"url", (Object)url));
        driver.getCommandExecutor().execute(command);
        return AbstractTest.asPage(pageClassToProxy);
    }

    public static WebDriver getPopup() {
        return AbstractTest.switchToPopup(null);
    }

    public static WebDriver switchToPopup(String text) {
        String currentWindow = null;
        try {
            currentWindow = driver.getWindowHandle();
        }
        catch (NoSuchWindowException noSuchWindowException) {
            // empty catch block
        }
        for (String popup : driver.getWindowHandles()) {
            if (popup.equals(currentWindow)) continue;
            driver.switchTo().window(popup);
            if (text != null && !driver.getCurrentUrl().contains(text)) continue;
            return driver;
        }
        throw new NotFoundException("Popup not found: " + text);
    }

    public static <T> T asPage(Class<T> pageClassToProxy) {
        T page = AbstractTest.instantiatePage(pageClassToProxy);
        return AbstractTest.fillElement(pageClassToProxy, page);
    }

    public static <T extends WebFragment> T getWebFragment(By by, Class<T> webFragmentClass) {
        WebElement element = Locator.findElementWithTimeout(by);
        return AbstractTest.getWebFragment(element, webFragmentClass);
    }

    public static <T extends WebFragment> T getWebFragment(WebElement element, Class<T> webFragmentClass) {
        Object webFragment = AbstractTest.instantiateWebFragment(element, webFragmentClass);
        webFragment = (WebFragment)AbstractTest.fillElement(webFragmentClass, webFragment);
        webFragment.setElement(element);
        return (T)webFragment;
    }

    public static <T> T fillElement(Class<T> pageClassToProxy, T page) {
        Object res;
        PageFactory.initElements((ElementLocatorFactory)new VariableElementLocatorFactory((WebDriver)driver, 10), page);
        ArrayList<String> fieldNames = new ArrayList<String>();
        ArrayList<WrapsElement> elements = new ArrayList<WrapsElement>();
        for (Field field : pageClassToProxy.getDeclaredFields()) {
            if (field.getAnnotation(Required.class) == null) continue;
            try {
                field.setAccessible(true);
                fieldNames.add(field.getName());
                elements.add((WrapsElement)field.get(page));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        FluentWait wait = new FluentWait(page).withTimeout(30L, TimeUnit.SECONDS).pollingEvery(100L, TimeUnit.MILLISECONDS);
        try {
            res = wait.until(aPage -> {
                String notLoaded = AbstractTest.anyElementNotLoaded(elements, fieldNames);
                if (notLoaded == null) {
                    return aPage;
                }
                return null;
            });
        }
        catch (TimeoutException e) {
            throw new TimeoutException("not loaded: " + AbstractTest.anyElementNotLoaded(elements, fieldNames), (Throwable)e);
        }
        if (pageClassToProxy.isAnnotationPresent(WaitForJQueryAjaxOnLoading.class)) {
            new AjaxRequestManager((WebDriver)driver).waitForJQueryRequests();
        }
        return (T)res;
    }

    protected static String anyElementNotLoaded(List<WrapsElement> proxies, List<String> fieldNames) {
        for (int i = 0; i < proxies.size(); ++i) {
            WrapsElement proxy = proxies.get(i);
            try {
                proxy.getWrappedElement();
                continue;
            }
            catch (NoSuchElementException e) {
                return fieldNames.get(i);
            }
        }
        return null;
    }

    protected static <T> T instantiatePage(Class<T> pageClassToProxy) {
        try {
            try {
                Constructor<T> constructor = pageClassToProxy.getConstructor(WebDriver.class);
                return constructor.newInstance(driver);
            }
            catch (NoSuchMethodException e) {
                return pageClassToProxy.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected static <T extends WebFragment> T instantiateWebFragment(WebElement element, Class<T> webFragmentClass) {
        try {
            try {
                Constructor<T> constructor = webFragmentClass.getConstructor(WebDriver.class, WebElement.class);
                return (T)((WebFragment)constructor.newInstance(driver, element));
            }
            catch (NoSuchMethodException e) {
                return (T)((WebFragment)webFragmentClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public LoginPage getLoginPage() {
        return AbstractTest.get(NUXEO_URL + "/logout", LoginPage.class, new JavaScriptErrorCollector.JavaScriptErrorIgnoreRule[0]);
    }

    public LoginPage logout() {
        JavaScriptErrorCollector.from((WebDriver)driver).ignore(this.ignores).checkForErrors();
        return this.getLoginPage();
    }

    public void logoutSimply() {
        driver.get(NUXEO_URL + "/logout");
    }

    public <T extends AbstractPage> T nav(Class<T> pageClass, String linkText) {
        WebElement link = Locator.findElementWithTimeout(By.linkText((String)linkText));
        if (link == null) {
            return null;
        }
        link.click();
        return (T)((AbstractPage)AbstractTest.asPage(pageClass));
    }

    public void navToUrl(String urlString) throws MalformedURLException {
        URL url = new URL(urlString);
        driver.navigate().to(url);
    }

    public DocumentBasePage login() throws DocumentBasePage.UserNotConnectedException {
        return this.login("Administrator", "Administrator");
    }

    public DocumentBasePage login(String username, String password) throws DocumentBasePage.UserNotConnectedException {
        DocumentBasePage documentBasePage = this.getLoginPage().login(username, password, DocumentBasePage.class);
        documentBasePage.checkUserConnected(username);
        return documentBasePage;
    }

    public DocumentBasePage loginAsTestUser() throws DocumentBasePage.UserNotConnectedException {
        return this.login(TEST_USERNAME, TEST_PASSWORD);
    }

    public LoginPage loginInvalid(String username, String password) {
        return this.getLoginPage().login(username, password, LoginPage.class);
    }

    @Deprecated
    protected DocumentBasePage initRepository(DocumentBasePage currentPage) throws Exception {
        return this.createWorkspace(currentPage, "Test Workspace", "Test Workspace for my dear WebDriver.");
    }

    @Deprecated
    protected void cleanRepository(DocumentBasePage currentPage) throws Exception {
        this.deleteWorkspace(currentPage, "Test Workspace");
    }

    @Deprecated
    protected DocumentBasePage createWorkspace(DocumentBasePage currentPage, String workspaceTitle, String workspaceDescription) {
        return currentPage.createWorkspace(workspaceTitle, workspaceDescription);
    }

    @Deprecated
    protected void deleteWorkspace(DocumentBasePage currentPage, String workspaceTitle) {
        currentPage.deleteWorkspace(workspaceTitle);
    }

    @Deprecated
    protected FileDocumentBasePage createFile(DocumentBasePage currentPage, String fileTitle, String fileDescription, boolean uploadBlob, String filePrefix, String fileSuffix, String fileContent) throws IOException {
        return currentPage.createFile(fileTitle, fileDescription, uploadBlob, filePrefix, fileSuffix, fileContent);
    }

    @Deprecated
    protected DocumentBasePage createCollections(DocumentBasePage currentPage, String collectionsTitle, String fileDescription) {
        return currentPage.createCollections(collectionsTitle, fileDescription);
    }

    @Deprecated
    protected CollectionContentTabSubPage createCollection(DocumentBasePage currentPage, String collectionsTitle, String fileDescription) {
        return currentPage.createCollection(collectionsTitle, fileDescription);
    }

    public static String getTmpFileToUploadPath(String filePrefix, String fileSuffix, String fileContent) throws IOException {
        File tmpFile = Framework.createTempFile((String)filePrefix, (String)fileSuffix);
        tmpFile.deleteOnExit();
        FileUtils.writeStringToFile((File)tmpFile, (String)fileContent, (Charset)StandardCharsets.UTF_8);
        Assert.assertTrue((boolean)tmpFile.exists());
        Assert.assertEquals((Object)"file", (Object)tmpFile.toURI().toURL().getProtocol());
        return tmpFile.getAbsolutePath();
    }

    protected String getCurrentDocumentId() {
        return (String)driver.executeScript("return ctx.currentDocument;", new Object[0]);
    }

    @Deprecated
    protected NoteDocumentBasePage createNote(DocumentBasePage currentPage, String noteTitle, String noteDescription, boolean defineNote, String noteContent) throws IOException {
        return currentPage.createNote(noteTitle, noteDescription, defineNote, noteContent);
    }
}

