/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.functionaltests;

import com.google.common.base.Function;
import org.nuxeo.functionaltests.Locator;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.WebDriver;

public class EventListener {
    private static int COUNT = 0;
    private final String id = "evt_listener_" + COUNT++;
    private final String event;
    private final String selector;
    private final JavascriptExecutor js;

    public EventListener(WebDriver driver, String event, String selector) {
        this.event = event;
        this.selector = selector;
        this.js = (JavascriptExecutor)driver;
        this.listen();
    }

    public void listen() {
        StringBuilder sb = new StringBuilder();
        sb.append("window.").append(this.id).append(" = 0;").append("var els = document.querySelectorAll('").append(this.selector).append("');").append("for (var i=0; i<els.length; i++) {").append("  els[i].addEventListener('").append(this.event).append("', function(e) { window.").append(this.id).append("++; });").append("}");
        this.js.executeScript(sb.toString(), new Object[0]);
    }

    public void waitCalled() {
        this.waitCalled(1);
    }

    public void waitCalled(int times) {
        this.waitUntil((Function<WebDriver, Boolean>)((Function)driver -> (Boolean)this.js.executeScript("return window." + this.id + " == " + times + ";", new Object[0])));
    }

    public void reset() {
        this.js.executeScript("window." + this.id + " = 0;", new Object[0]);
    }

    private void waitUntil(Function<WebDriver, Boolean> function) {
        Locator.waitUntilGivenFunctionIgnoring(function, NoSuchElementException.class);
    }
}

