/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.functionaltests.contentView;

import org.junit.Assert;
import org.nuxeo.functionaltests.AbstractTest;
import org.nuxeo.functionaltests.Locator;
import org.nuxeo.functionaltests.fragment.WebFragmentImpl;
import org.nuxeo.functionaltests.pages.AbstractPage;
import org.nuxeo.functionaltests.pages.DocumentBasePage;
import org.openqa.selenium.Alert;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;

public class ContentViewSelectionActions
extends WebFragmentImpl {
    public static final String DELETE = "Delete";

    public ContentViewSelectionActions(WebDriver driver, WebElement element) {
        super(driver, element);
    }

    public DocumentBasePage delete() {
        return this.delete(DocumentBasePage.class);
    }

    public <T extends AbstractPage> T delete(Class<T> pageClassToProxy) {
        this.clickOnActionByTitle(DELETE);
        Alert alert = this.driver.switchTo().alert();
        Assert.assertEquals((Object)"Delete selected document(s)?", (Object)alert.getText());
        alert.accept();
        return (T)((AbstractPage)AbstractTest.asPage(pageClassToProxy));
    }

    public void clickOnActionByTitle(String title) {
        Locator.waitUntilEnabledAndClick(this.getActionByTitle(title));
    }

    public <T extends AbstractPage> T clickOnActionByTitle(String title, Class<T> pageClassToProxy) {
        this.clickOnActionByTitle(title);
        return (T)((AbstractPage)AbstractTest.asPage(pageClassToProxy));
    }

    public WebElement getActionByTitle(String title) {
        return this.getElement().findElement(By.xpath((String)("//input[@value=\"" + title + "\"]")));
    }
}

