/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.functionaltests.contentView;

import org.nuxeo.functionaltests.AbstractTest;
import org.nuxeo.functionaltests.AjaxRequestManager;
import org.nuxeo.functionaltests.Locator;
import org.nuxeo.functionaltests.Required;
import org.nuxeo.functionaltests.fragment.WebFragmentImpl;
import org.nuxeo.functionaltests.pages.DocumentBasePage;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;

public class PageNavigationControls
extends WebFragmentImpl {
    @Required
    @FindBy(xpath="//input[@alt='Rewind']")
    WebElement firstButton;
    @Required
    @FindBy(xpath="//input[@alt='Previous']")
    WebElement previousButton;
    @Required
    @FindBy(className="currentPageStatus")
    WebElement status;
    @Required
    @FindBy(xpath="//input[@alt='Next']")
    WebElement nextButton;
    @Required
    @FindBy(xpath="//input[@alt='Fast Forward']")
    WebElement lastButton;

    public PageNavigationControls(WebDriver driver, WebElement element) {
        super(driver, element);
    }

    public DocumentBasePage first() {
        return this.first(DocumentBasePage.class);
    }

    public <T extends DocumentBasePage> T first(Class<T> pageClassToProxy) {
        return this.clickWithAjax(this.firstButton, pageClassToProxy);
    }

    public DocumentBasePage previous() {
        return this.previous(DocumentBasePage.class);
    }

    public <T extends DocumentBasePage> T previous(Class<T> pageClassToProxy) {
        return this.clickWithAjax(this.previousButton, pageClassToProxy);
    }

    public int getCurrentPage() {
        return Integer.parseInt(this.status.getText().split("/")[0]);
    }

    public int getLastPage() {
        return Integer.parseInt(this.status.getText().split("/")[1]);
    }

    public DocumentBasePage next() {
        return this.next(DocumentBasePage.class);
    }

    public <T extends DocumentBasePage> T next(Class<T> pageClassToProxy) {
        return this.clickWithAjax(this.nextButton, pageClassToProxy);
    }

    public DocumentBasePage last() {
        return this.last(DocumentBasePage.class);
    }

    public <T extends DocumentBasePage> T last(Class<T> pageClassToProxy) {
        return this.clickWithAjax(this.lastButton, pageClassToProxy);
    }

    protected <T extends DocumentBasePage> T clickWithAjax(WebElement button, Class<T> pageClassToProxy) {
        AjaxRequestManager arm = new AjaxRequestManager(this.driver);
        arm.begin();
        Locator.waitUntilEnabledAndClick(button);
        arm.end();
        return (T)((DocumentBasePage)AbstractTest.asPage(pageClassToProxy));
    }
}

