/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.functionaltests.forms;

import java.io.IOException;
import org.nuxeo.functionaltests.AbstractTest;
import org.nuxeo.functionaltests.Locator;
import org.nuxeo.functionaltests.forms.AbstractWidgetElement;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;

public class FileWidgetElement
extends AbstractWidgetElement {
    public FileWidgetElement(WebDriver driver, String id) {
        super(driver, id);
    }

    public String getEditChoice() {
        for (InputFileChoice choice : InputFileChoice.values()) {
            String subid = choice.getOptionId();
            if (!this.hasSubElement(subid) || !this.getSubElement(subid).isSelected()) continue;
            return choice.name();
        }
        return null;
    }

    public String getFilename(boolean isEdit) {
        WebElement link = isEdit ? this.getSubElement("default_download:download") : this.getSubElement("download");
        return link.getText();
    }

    public void uploadTestFile(String prefix, String suffix, String content) throws IOException {
        String fileToUploadPath = AbstractTest.getTmpFileToUploadPath(prefix, suffix, content);
        this.uploadFile(fileToUploadPath);
    }

    public void uploadFile(String filePath) throws IOException {
        this.selectChoice(InputFileChoice.upload);
        WebElement fileInput = this.getSubElement("upload");
        fileInput.sendKeys(new CharSequence[]{filePath});
    }

    public void removeFile() {
        if (this.hasChoice(InputFileChoice.none)) {
            this.selectChoice(InputFileChoice.none);
        } else if (this.hasChoice(InputFileChoice.delete)) {
            this.selectChoice(InputFileChoice.delete);
        } else {
            throw new NoSuchElementException("No delete choice available on widget");
        }
    }

    public void keepFile() {
        if (this.hasChoice(InputFileChoice.keep)) {
            this.selectChoice(InputFileChoice.keep);
        } else if (this.hasChoice(InputFileChoice.tempKeep)) {
            this.selectChoice(InputFileChoice.tempKeep);
        } else {
            throw new NoSuchElementException("No keep choice available on widget");
        }
    }

    public boolean hasChoice(InputFileChoice choice) {
        return this.hasSubElement(choice.getOptionId());
    }

    public void selectChoice(InputFileChoice choice) {
        String id = choice.getOptionId();
        if (!this.hasSubElement(id)) {
            throw new NoSuchElementException("No '" + choice.name() + "' choice available on widget");
        }
        Locator.waitUntilEnabledAndClick(this.getSubElement(id));
    }

    public static enum InputFileChoice {
        none,
        keep,
        upload,
        delete,
        tempKeep;


        public String getOptionId() {
            return "choice" + this.name();
        }
    }
}

