/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.functionaltests.forms;

import java.lang.reflect.Constructor;
import java.util.Map;
import org.nuxeo.functionaltests.AbstractTest;
import org.nuxeo.functionaltests.Assert;
import org.nuxeo.functionaltests.Locator;
import org.nuxeo.functionaltests.forms.LayoutFragment;
import org.nuxeo.functionaltests.forms.WidgetElement;
import org.nuxeo.functionaltests.fragment.WebFragment;
import org.openqa.selenium.By;
import org.openqa.selenium.Keys;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;

public class LayoutElement
implements LayoutFragment {
    protected final WebDriver driver;
    protected String id;

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public LayoutElement(WebDriver driver, String id) {
        this.driver = driver;
        this.id = id;
    }

    @Override
    public String getSubElementId(String id) {
        Object finalId = id;
        if (this.id != null) {
            finalId = this.id.endsWith(":") ? this.id + id : this.id + ":" + id;
        }
        return finalId;
    }

    protected <T> T instantiateWidget(String id, Class<T> pageClassToProxy) {
        try {
            try {
                Constructor<T> constructor = pageClassToProxy.getConstructor(WebDriver.class, String.class);
                return constructor.newInstance(this.driver, this.getSubElementId(id));
            }
            catch (NoSuchMethodException e) {
                return pageClassToProxy.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public WidgetElement getWidget(String id) {
        return this.getWidget(id, WidgetElement.class);
    }

    @Override
    public <T> T getWidget(String id, Class<T> widgetClassToProxy) {
        T res = this.instantiateWidget(id, widgetClassToProxy);
        res = AbstractTest.fillElement(widgetClassToProxy, res);
        return res;
    }

    protected boolean hasSubElement(String id) {
        return Assert.hasElement(By.id((String)this.getSubElementId(id)));
    }

    public WebElement getElement(String id) {
        return Locator.findElement(By.id((String)id));
    }

    public WebElement getElement(String id, boolean wait) {
        return Locator.findElementWithTimeout(By.id((String)id));
    }

    @Override
    public WebElement getSubElement(String id) {
        return this.getElement(this.getSubElementId(id));
    }

    @Override
    public WebElement getSubElement(String id, boolean wait) {
        return this.getElement(this.getSubElementId(id), wait);
    }

    public void setInput(WebElement elt, String value) {
        Locator.waitUntilEnabledAndClick(elt);
        if (value != null) {
            elt.sendKeys(new CharSequence[]{Keys.chord((CharSequence[])new CharSequence[]{Keys.CONTROL, "a"}), Keys.chord((CharSequence[])new CharSequence[]{Keys.COMMAND, "a"}), value});
        }
    }

    public void setInput(String id, String value) {
        WebElement elt = this.getSubElement(id);
        this.setInput(elt, value);
    }

    public void setInput(Map<String, String> entries) {
        if (entries == null || entries.isEmpty()) {
            return;
        }
        for (Map.Entry<String, String> entry : entries.entrySet()) {
            this.setInput(entry.getKey(), entry.getValue());
        }
    }

    public <T extends WebFragment> T getWebFragment(String id, Class<T> webFragmentClass) {
        return AbstractTest.getWebFragment(By.id((String)this.getSubElementId(id)), webFragmentClass);
    }
}

