/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.functionaltests.fragment;

import com.google.common.base.Function;
import java.util.List;
import org.nuxeo.functionaltests.AbstractTest;
import org.nuxeo.functionaltests.Locator;
import org.nuxeo.functionaltests.fragment.AddToCollectionForm;
import org.nuxeo.functionaltests.pages.DocumentBasePage;
import org.openqa.selenium.By;
import org.openqa.selenium.StaleElementReferenceException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;

public class AddAllToCollectionForm
extends AddToCollectionForm {
    private static final String ADD_BUTTON_ID = "document_content_buttons:nxw_addSelectedToCollectionAction_after_view_fancy_subview:nxw_addSelectedToCollectionAction_after_view_fancyform:addAll";
    private static final String S2_CHOOSE_COLLECTION_ID = "s2id_document_content_buttons:nxw_addSelectedToCollectionAction_after_view_fancy_subview:nxw_addSelectedToCollectionAction_after_view_fancyform:nxw_singleDocumentSuggestion_2_select2";
    private static final String NEW_COLLECTION_DESCRIPTION_ID = "document_content_buttons:nxw_addSelectedToCollectionAction_after_view_fancy_subview:nxw_addSelectedToCollectionAction_after_view_fancyform:description";
    private static final String EXISTING_COLLECTION_DESCRIPTION_ID = "document_content_buttons:nxw_addSelectedToCollectionAction_after_view_fancy_subview:nxw_addSelectedToCollectionAction_after_view_fancyform:scd";

    public AddAllToCollectionForm(WebDriver driver, WebElement element) {
        super(driver, element);
        this.multiple = true;
    }

    public DocumentBasePage addAll() {
        return this.addAll(DocumentBasePage.class);
    }

    public <T> T addAll(Class<T> pageClassProxy) {
        Locator.findElementWaitUntilEnabledAndClick(By.id((String)ADD_BUTTON_ID));
        return AbstractTest.asPage(pageClassProxy);
    }

    @Override
    protected String getAddButtonId() {
        return ADD_BUTTON_ID;
    }

    @Override
    protected String getChooseCollectionId() {
        return S2_CHOOSE_COLLECTION_ID;
    }

    @Override
    protected String getNewCollectionDescriptionId() {
        return NEW_COLLECTION_DESCRIPTION_ID;
    }

    @Override
    protected String getCollectionDescriptionId() {
        return EXISTING_COLLECTION_DESCRIPTION_ID;
    }

    public void removeDocumentToBeAddedToCollection(int index) {
        if (!this.isMultiple()) {
            throw new UnsupportedOperationException("You are not adding many documents to the collection");
        }
        List docsToBeAdded = this.getElement().findElements(By.xpath((String)"//div[@class='simpleBox']"));
        final int docsToBeAddedSize = docsToBeAdded.size();
        ((WebElement)docsToBeAdded.get(index)).findElement(By.xpath((String)"a")).click();
        Locator.waitUntilGivenFunctionIgnoring(new Function<WebDriver, Boolean>(){

            public Boolean apply(WebDriver driver) {
                return AddAllToCollectionForm.this.getElement().findElements(By.xpath((String)"//div[@class='simpleBox']")).size() == docsToBeAddedSize - 1;
            }
        }, StaleElementReferenceException.class);
    }
}

