/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.functionaltests.fragment;

import org.nuxeo.functionaltests.Locator;
import org.nuxeo.functionaltests.Required;
import org.nuxeo.functionaltests.forms.Select2WidgetElement;
import org.nuxeo.functionaltests.fragment.WebFragmentImpl;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;

public class NewVocabularyEntryForm
extends WebFragmentImpl {
    @FindBy(id="addEntryView:addEntryForm:nxl_l10nsubjects_vocabulary:nxw_l10nxvocabulary_label_en")
    @Required
    private WebElement englishLabelInput;
    @FindBy(id="addEntryView:addEntryForm:nxl_l10nsubjects_vocabulary:nxw_l10nxvocabulary_label_fr")
    @Required
    private WebElement frenchLabelInput;
    @FindBy(id="addEntryView:addEntryForm:nxl_l10nsubjects_vocabulary:nxw_l10nxvocabulary_id")
    @Required
    private WebElement idInput;
    @FindBy(id="s2id_addEntryView:addEntryForm:nxl_l10nsubjects_vocabulary:nxw_parent_select2")
    private WebElement newParentSuggestion;
    @FindBy(id="addEntryView:addEntryForm:nxl_l10nsubjects_vocabulary:nxw_l10nxvocabulary_obsolete_checkbox:0")
    @Required
    private WebElement notObsoleteInput;
    @FindBy(id="addEntryView:addEntryForm:nxl_l10nsubjects_vocabulary:nxw_l10nxvocabulary_obsolete_checkbox:1")
    @Required
    private WebElement obsoleteInput;
    @FindBy(id="addEntryView:addEntryForm:nxl_l10nsubjects_vocabulary:nxw_l10nxvocabulary_order")
    @Required
    private WebElement orderInput;

    public NewVocabularyEntryForm(WebDriver driver, WebElement element) {
        super(driver, element);
    }

    public void save() {
        Locator.waitUntilEnabledAndClick(this.getElement().findElement(By.xpath((String)"//input[@value='Create']")));
    }

    public void setNewVocabularyEnglishLabel(String vocabularyEnglishLabel) {
        this.englishLabelInput.sendKeys(new CharSequence[]{vocabularyEnglishLabel});
    }

    public void setNewVocabularyFrenchLabel(String vocabularyFrenchLabel) {
        this.frenchLabelInput.sendKeys(new CharSequence[]{vocabularyFrenchLabel});
    }

    public void setNewVocabularyId(String vocabularyId) {
        this.idInput.sendKeys(new CharSequence[]{vocabularyId});
    }

    public void setNewVocabularyObsolete(boolean obsolete) {
        if (obsolete) {
            Locator.waitUntilEnabledAndClick(this.obsoleteInput);
        } else {
            Locator.waitUntilEnabledAndClick(this.notObsoleteInput);
        }
    }

    public void setNewVocabularyOrder(int vocabularyOrder) {
        this.orderInput.clear();
        this.orderInput.sendKeys(new CharSequence[]{"" + vocabularyOrder});
    }

    public void setNewVocabularyParentId(String parentLabelPath) {
        Select2WidgetElement select2 = new Select2WidgetElement(this.driver, this.newParentSuggestion, false);
        select2.selectValue(parentLabelPath);
    }
}

