/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.functionaltests.pages;

import com.google.common.base.Function;
import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.Assert;
import org.nuxeo.functionaltests.AjaxRequestManager;
import org.nuxeo.functionaltests.Locator;
import org.nuxeo.functionaltests.Required;
import org.nuxeo.functionaltests.fragment.AddAllToCollectionForm;
import org.nuxeo.functionaltests.fragment.AddToCollectionForm;
import org.nuxeo.functionaltests.pages.AbstractPage;
import org.nuxeo.functionaltests.pages.FileDocumentBasePage;
import org.nuxeo.functionaltests.pages.FolderDocumentBasePage;
import org.nuxeo.functionaltests.pages.HomePage;
import org.nuxeo.functionaltests.pages.NavigationSubPage;
import org.nuxeo.functionaltests.pages.NoteDocumentBasePage;
import org.nuxeo.functionaltests.pages.UserHomePage;
import org.nuxeo.functionaltests.pages.actions.ContextualActions;
import org.nuxeo.functionaltests.pages.admincenter.AdminCenterBasePage;
import org.nuxeo.functionaltests.pages.forms.CollectionCreationFormPage;
import org.nuxeo.functionaltests.pages.forms.DublinCoreCreationDocumentFormPage;
import org.nuxeo.functionaltests.pages.forms.FileCreationFormPage;
import org.nuxeo.functionaltests.pages.forms.FolderCreationFormPage;
import org.nuxeo.functionaltests.pages.forms.ForumCreationFormPage;
import org.nuxeo.functionaltests.pages.forms.NoteCreationFormPage;
import org.nuxeo.functionaltests.pages.forms.WorkspaceCreationFormPage;
import org.nuxeo.functionaltests.pages.search.SearchPage;
import org.nuxeo.functionaltests.pages.tabs.CollectionContentTabSubPage;
import org.nuxeo.functionaltests.pages.tabs.CommentsTabSubPage;
import org.nuxeo.functionaltests.pages.tabs.ContentTabSubPage;
import org.nuxeo.functionaltests.pages.tabs.EditTabSubPage;
import org.nuxeo.functionaltests.pages.tabs.FilesTabSubPage;
import org.nuxeo.functionaltests.pages.tabs.ForumTabSubPage;
import org.nuxeo.functionaltests.pages.tabs.HistoryTabSubPage;
import org.nuxeo.functionaltests.pages.tabs.ManageTabSubPage;
import org.nuxeo.functionaltests.pages.tabs.PermissionsSubPage;
import org.nuxeo.functionaltests.pages.tabs.PublishTabSubPage;
import org.nuxeo.functionaltests.pages.tabs.RelationTabSubPage;
import org.nuxeo.functionaltests.pages.tabs.SectionContentTabSubPage;
import org.nuxeo.functionaltests.pages.tabs.SectionsContentTabSubPage;
import org.nuxeo.functionaltests.pages.tabs.SummaryTabSubPage;
import org.nuxeo.functionaltests.pages.tabs.TopicTabSubPage;
import org.nuxeo.functionaltests.pages.tabs.WorkflowTabSubPage;
import org.nuxeo.functionaltests.pages.tabs.WorkspacesContentTabSubPage;
import org.nuxeo.functionaltests.pages.workspace.WorkspaceHomePage;
import org.openqa.selenium.By;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.StaleElementReferenceException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;

public class DocumentBasePage
extends AbstractPage {
    private static final Log log = LogFactory.getLog(DocumentBasePage.class);
    @FindBy(xpath="//form[@id='breadcrumbForm']")
    public WebElement breadcrumbForm;
    @FindBy(xpath="//div[@id='nxw_documentTabs_panel']//a/span[text()='Content']")
    public WebElement contentTabLink;
    public ContextualActions contextualActions;
    @FindBy(className="creator")
    public WebElement currentDocumentContributor;
    @FindBy(className="documentDescription")
    public WebElement currentDocumentDescription;
    @FindBy(xpath="//form[@id='document_header_layout_form']//h1")
    public WebElement currentDocumentTitle;
    @FindBy(className="currentDocumentDescription")
    public WebElement currentFolderishDescription;
    @FindBy(linkText="WORKSPACE")
    public WebElement documentManagementLink;
    @FindBy(xpath="//div[@id='nxw_documentTabs_panel']//a/span[text()='Edit']")
    public WebElement editTabLink;
    @FindBy(xpath="//div[@id='nxw_documentTabs_panel']//a/span[text()='Files']")
    public WebElement filesTabLink;
    @FindBy(xpath="//div[@id='nxw_documentTabs_panel']//a/span[text()='Permissions']")
    public WebElement permissionsTabLink;
    @FindBy(xpath="//div[@id='nxw_documentTabs_panel']//a/span[text()='History']")
    public WebElement historyTabLink;
    @FindBy(xpath="//div[@id='nxw_documentTabs_panel']//a/span[text()='Manage']")
    public WebElement manageTabLink;
    @FindBy(xpath="//div[@id='nxw_documentTabs_panel']//a/span[text()='Relations']")
    public WebElement relationTabLink;
    @FindBy(xpath="//div[@id='nxw_documentTabs_panel']//a/span[text()='Summary']")
    public WebElement summaryTabLink;
    @FindBy(xpath="//div[@id='nxw_documentTabs_panel']//a/span[text()='Publish']")
    public WebElement publishTabLink;
    @FindBy(xpath="//div[@id='nxw_documentTabs_panel']//a/span[text()='Comments']")
    public WebElement commentsTabLink;
    @FindBy(xpath="//div[@id='nxw_documentTabs_panel']//a/span[text()='Forum']")
    public WebElement forumTabLink;
    @FindBy(xpath="//div[@id='nxw_documentTabs_panel']//a/span[text()='Topic']")
    public WebElement topicTabLink;
    @Required
    @FindBy(xpath="//div[@id='nxw_documentTabs_panel']")
    public WebElement tabsBar;
    @FindBy(xpath="//div[@id='nxw_documentTabs_panel']//a/span[text()='Workflow']")
    public WebElement workflowLink;
    @Required
    @FindBy(id="nxw_userMenuActions_panel")
    public WebElement userMenuActions;
    @Required
    @FindBy(linkText="HOME")
    public WebElement homePageLink;
    @Required
    @FindBy(linkText="SEARCH")
    public WebElement searchPageLink;
    private static final String ADD_TO_COLLECTION_UPPER_ACTION_ID = "nxw_addToCollectionAction_form:nxw_addToCollectionAction_link";
    private static final String ADD_ALL_TO_COLLECTION_ACTION_ID = "document_content_buttons:nxw_addSelectedToCollectionAction_form:nxw_addSelectedToCollectionAction_link";
    @FindBy(id="nxw_addToCollectionAction_form:nxw_addToCollectionAction_link")
    private WebElement addToCollectionUpperAction;
    @FindBy(id="document_content_buttons:nxw_addSelectedToCollectionAction_form:nxw_addSelectedToCollectionAction_link")
    private WebElement addAllToCollectionAction;

    public DocumentBasePage(WebDriver driver) {
        super(driver);
    }

    public void checkDocTitle(String expectedTitle) {
        Assert.assertEquals((Object)expectedTitle, (Object)this.getCurrentDocumentTitle());
    }

    public void checkUserConnected(String username) throws UserNotConnectedException {
        try {
            DocumentBasePage.findElementWithTimeout(By.cssSelector((String)("span." + username)));
        }
        catch (NoSuchElementException e) {
            throw new UserNotConnectedException(username);
        }
    }

    public void clickOnDocumentTabLink(WebElement tabLink) {
        this.clickOnDocumentTabLink(tabLink, this.useAjaxTabs());
    }

    public void clickOnDocumentTabLink(WebElement tabLink, boolean useAjax) {
        this.clickOnTabIfNotSelected("nxw_documentTabs_panel", tabLink, useAjax);
    }

    public AdminCenterBasePage getAdminCenter() {
        DocumentBasePage.findElementWaitUntilEnabledAndClick(By.linkText((String)"ADMIN"));
        return this.asPage(AdminCenterBasePage.class);
    }

    public ContentTabSubPage getContentTab() {
        return this.getContentTab(ContentTabSubPage.class);
    }

    public <T> T getContentTab(Class<T> tabClass) {
        this.clickOnDocumentTabLink(this.contentTabLink);
        return this.asPage(tabClass);
    }

    public CollectionContentTabSubPage getCollectionContentTab() {
        return this.getContentTab(CollectionContentTabSubPage.class);
    }

    public ContextualActions getContextualActions() {
        return this.asPage(ContextualActions.class);
    }

    public List<WebElement> getBlobActions(int index) {
        return DocumentBasePage.findElementsWithTimeout(By.xpath((String)("(//div[@class='actionsColumn'])[" + (index + 1) + "]//a")));
    }

    public String getCurrentContributors() {
        return this.currentDocumentContributor.getText();
    }

    public String getCurrentDocumentDescription() {
        return this.currentDocumentDescription.getText();
    }

    public String getCurrentDocumentTitle() {
        return this.currentDocumentTitle.getText();
    }

    public String getCurrentFolderishDescription() {
        return this.currentFolderishDescription.getText();
    }

    public List<String> getCurrentStates() {
        return DocumentBasePage.findElementsWithTimeout(By.className((String)"sticker")).stream().map(WebElement::getText).collect(Collectors.toList());
    }

    @Deprecated
    public DocumentBasePage getDocumentManagement() {
        return this.goToWorkspaces();
    }

    public EditTabSubPage getEditTab() {
        return this.getEditTab(EditTabSubPage.class);
    }

    public <T extends EditTabSubPage> T getEditTab(Class<T> tabClass) {
        this.clickOnDocumentTabLink(this.editTabLink);
        return (T)((EditTabSubPage)this.asPage(tabClass));
    }

    public FilesTabSubPage getFilesTab() {
        this.clickOnDocumentTabLink(this.filesTabLink);
        return this.asPage(FilesTabSubPage.class);
    }

    public PermissionsSubPage getPermissionsTab() {
        this.clickOnDocumentTabLink(this.permissionsTabLink, false);
        return this.asPage(PermissionsSubPage.class);
    }

    public HistoryTabSubPage getHistoryTab() {
        this.clickOnDocumentTabLink(this.historyTabLink);
        return this.asPage(HistoryTabSubPage.class);
    }

    public ManageTabSubPage getManageTab() {
        this.clickOnDocumentTabLink(this.manageTabLink);
        return this.asPage(ManageTabSubPage.class);
    }

    public NavigationSubPage getNavigationSubPage() {
        return this.asPage(NavigationSubPage.class);
    }

    public RelationTabSubPage getRelationTab() {
        this.clickOnDocumentTabLink(this.relationTabLink);
        return this.asPage(RelationTabSubPage.class);
    }

    public SummaryTabSubPage getSummaryTab() {
        this.clickOnDocumentTabLink(this.summaryTabLink);
        return this.asPage(SummaryTabSubPage.class);
    }

    public CommentsTabSubPage getCommentsTab() {
        this.clickOnDocumentTabLink(this.commentsTabLink);
        return this.asPage(CommentsTabSubPage.class);
    }

    public ForumTabSubPage getForumTab() {
        this.clickOnDocumentTabLink(this.forumTabLink);
        return this.asPage(ForumTabSubPage.class);
    }

    public TopicTabSubPage getTopicTab() {
        this.clickOnDocumentTabLink(this.topicTabLink);
        return this.asPage(TopicTabSubPage.class);
    }

    public PublishTabSubPage getPublishTab() {
        this.clickOnDocumentTabLink(this.publishTabLink);
        return this.asPage(PublishTabSubPage.class);
    }

    public UserHomePage getUserHome() {
        DocumentBasePage.findElementWaitUntilEnabledAndClick(By.linkText((String)"HOME"));
        UserHomePage page = this.asPage(UserHomePage.class);
        return page.goToDashboard();
    }

    public WorkflowTabSubPage getWorkflow() {
        this.clickOnDocumentTabLink(this.workflowLink);
        return this.asPage(WorkflowTabSubPage.class);
    }

    public WorkspacesContentTabSubPage getWorkspacesContentTab() {
        this.clickOnDocumentTabLink(this.contentTabLink);
        return this.asPage(WorkspacesContentTabSubPage.class);
    }

    public DocumentBasePage goToDocumentByBreadcrumb(String documentTitle) {
        DocumentBasePage.clickOnBreadcrumbElement(this.driver, documentTitle);
        return this.asPage(DocumentBasePage.class);
    }

    public static void makeBreadcrumbUsable(WebDriver driver) {
        String[] ids;
        log.warn((Object)"Removing header elements to make breadcrumb usable");
        JavascriptExecutor executor = (JavascriptExecutor)driver;
        for (String id : ids = new String[]{"logolink", "nxw_mainTabs_panel", "nxw_userActions_panel", "nxw_userMenuActions_panel", "nxw_headerSearch_panel"}) {
            try {
                driver.findElement(By.id((String)id));
                executor.executeScript("return document.getElementById('" + id + "').remove()", new Object[0]);
            }
            catch (NoSuchElementException noSuchElementException) {
                // empty catch block
            }
        }
    }

    public static void clickOnBreadcrumbElement(WebDriver driver, String documentTitle) {
        DocumentBasePage.makeBreadcrumbUsable(driver);
        WebElement breadcrumb = driver.findElement(By.xpath((String)"//form[@id='breadcrumbForm']"));
        Locator.waitUntilEnabledAndClick(breadcrumb.findElement(By.linkText((String)documentTitle)));
    }

    public AddToCollectionForm getAddToCollectionPopup() {
        AjaxRequestManager arm = new AjaxRequestManager(this.driver);
        arm.begin();
        DocumentBasePage.waitUntilEnabledAndClick(this.addToCollectionUpperAction);
        arm.end();
        WebElement elt = AbstractPage.getFancyBoxContent();
        return this.getWebFragment(elt, AddToCollectionForm.class);
    }

    @Deprecated
    public AddAllToCollectionForm getAddAllToCollectionPopup() {
        Locator.waitUntilGivenFunctionIgnoring((Function<WebDriver, Boolean>)((Function)driver -> StringUtils.isBlank((CharSequence)driver.findElement(By.id((String)ADD_ALL_TO_COLLECTION_ACTION_ID)).getAttribute("disabled"))), StaleElementReferenceException.class);
        AjaxRequestManager arm = new AjaxRequestManager(this.driver);
        arm.begin();
        DocumentBasePage.findElementWaitUntilEnabledAndClick(By.id((String)ADD_ALL_TO_COLLECTION_ACTION_ID));
        arm.end();
        WebElement elt = AbstractPage.getFancyBoxContent();
        return this.getWebFragment(elt, AddAllToCollectionForm.class);
    }

    public boolean isAddToCollectionUpperActionAvailable() {
        try {
            this.driver.findElement(By.id((String)ADD_TO_COLLECTION_UPPER_ACTION_ID));
            return true;
        }
        catch (NoSuchElementException e) {
            return false;
        }
    }

    public void popupUserMenuActions() {
        Locator.findElementWaitUntilEnabledAndClick(this.userMenuActions, By.id((String)"nxw_userMenuActions_dropDownMenu"));
        Locator.waitUntilGivenFunctionIgnoring((Function<WebDriver, Boolean>)((Function)driver -> !this.userMenuActions.findElement(By.xpath((String)"//ul[@class='actionSubList']")).getAttribute("style").equals("display: none;")), StaleElementReferenceException.class);
    }

    public DocumentBasePage switchToPersonalWorkspace() {
        this.popupUserMenuActions();
        DocumentBasePage.findElementWaitUntilEnabledAndClick(By.linkText((String)"Personal Workspace"));
        return this.asPage(DocumentBasePage.class);
    }

    public DocumentBasePage switchToDocumentBase() {
        this.popupUserMenuActions();
        DocumentBasePage.findElementWaitUntilEnabledAndClick(By.linkText((String)"Back to Document Base"));
        return this.asPage(DocumentBasePage.class);
    }

    public HomePage goToHomePage() {
        DocumentBasePage.waitUntilEnabledAndClick(this.homePageLink);
        return this.asPage(HomePage.class);
    }

    public SearchPage goToSearchPage() {
        DocumentBasePage.waitUntilEnabledAndClick(this.searchPageLink);
        return this.asPage(SearchPage.class);
    }

    public WorkspaceHomePage goToWorkspaces() {
        DocumentBasePage.waitUntilEnabledAndClick(this.documentManagementLink);
        return this.asPage(WorkspaceHomePage.class);
    }

    public boolean isMainTabSelected(WebElement tab) {
        WebElement elt = Locator.findParentTag(tab, "li");
        String css = elt.getAttribute("class");
        return css != null && css.contains("selected");
    }

    public DocumentBasePage createWorkspace(String workspaceTitle, String workspaceDescription) {
        DocumentBasePage workspacesPage = this.getNavigationSubPage().goToDocument("Workspaces");
        WorkspaceCreationFormPage workspaceCreationFormPage = workspacesPage.getWorkspacesContentTab().getWorkspaceCreatePage();
        DocumentBasePage workspacePage = workspaceCreationFormPage.createNewWorkspace(workspaceTitle, workspaceDescription);
        return workspacePage;
    }

    public DocumentBasePage createSection(String sectionTitle, String sectionDescription) {
        this.getNavigationSubPage().goToDocument("Sections");
        DublinCoreCreationDocumentFormPage sectionCreationPage = this.asPage(SectionsContentTabSubPage.class).getSectionCreatePage();
        return sectionCreationPage.createDocument(sectionTitle, sectionDescription);
    }

    public void deleteWorkspace(String workspaceTitle) {
        DocumentBasePage workspacesPage = this.getNavigationSubPage().goToDocument("Workspaces");
        workspacesPage.getContentTab().removeDocument(workspaceTitle);
    }

    public FolderDocumentBasePage createFolder(String folderTitle, String folderDescription) {
        FolderCreationFormPage folderCreationFormPage = this.getContentTab().getDocumentCreatePage("Folder", FolderCreationFormPage.class);
        FolderDocumentBasePage folderPage = folderCreationFormPage.createFolderDocument(folderTitle, folderDescription);
        return folderPage;
    }

    public FileDocumentBasePage createFile(String fileTitle, String fileDescription, boolean uploadBlob, String filePrefix, String fileSuffix, String fileContent) throws IOException {
        FileCreationFormPage fileCreationFormPage = this.getContentTab().getDocumentCreatePage("File", FileCreationFormPage.class);
        FileDocumentBasePage filePage = fileCreationFormPage.createFileDocument(fileTitle, fileDescription, uploadBlob, filePrefix, fileSuffix, fileDescription);
        return filePage;
    }

    public DocumentBasePage createCollections(String collectionsTitle, String fileDescription) {
        DublinCoreCreationDocumentFormPage dublinCoreDocumentFormPage = this.getContentTab().getDocumentCreatePage("Collections", DublinCoreCreationDocumentFormPage.class);
        DocumentBasePage documentBasePage = dublinCoreDocumentFormPage.createDocument(collectionsTitle, fileDescription);
        return documentBasePage;
    }

    public CollectionContentTabSubPage createCollection(String collectionsTitle, String fileDescription) {
        CollectionCreationFormPage collectionCreationFormPage = this.getContentTab().getDocumentCreatePage("Collection", CollectionCreationFormPage.class);
        CollectionContentTabSubPage documentBasePage = collectionCreationFormPage.createDocument(collectionsTitle, fileDescription);
        return documentBasePage;
    }

    public NoteDocumentBasePage createNote(String noteTitle, String noteDescription, boolean defineNote, String noteContent) throws IOException {
        NoteCreationFormPage noteCreationPage = this.getContentTab().getDocumentCreatePage("Note", NoteCreationFormPage.class);
        NoteDocumentBasePage notePage = noteCreationPage.createNoteDocument(noteTitle, noteDescription, defineNote, noteContent);
        return notePage;
    }

    public ForumTabSubPage createForum(String forumTitle, String forumDescription) {
        ForumCreationFormPage forumCreationFormPage = this.getContentTab().getDocumentCreatePage("Forum", ForumCreationFormPage.class);
        ForumTabSubPage forumPage = forumCreationFormPage.createForumDocument(forumTitle, forumDescription);
        return forumPage;
    }

    public boolean hasNewRelationLink() {
        return this.getRelationTab().hasNewRelationLink();
    }

    public boolean hasFilesTab() {
        try {
            return this.getFilesTab() != null;
        }
        catch (NoSuchElementException e) {
            return false;
        }
    }

    public boolean hasNewButton(boolean isSection) {
        if (isSection) {
            return this.getContentTab(SectionContentTabSubPage.class).hasNewButton();
        }
        return this.getContentTab().hasNewButton();
    }

    public boolean hasEditTab() {
        try {
            return this.getEditTab() != null;
        }
        catch (NoSuchElementException e) {
            return false;
        }
    }

    public boolean hasNewPermissionsButton() {
        return this.getPermissionsTab().hasNewPermissionButton();
    }

    public boolean hasManageTab() {
        try {
            return this.getManageTab() != null;
        }
        catch (NoSuchElementException e) {
            return false;
        }
    }

    public class UserNotConnectedException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public UserNotConnectedException(String username) {
            super("The user " + username + " is expected to be connected but isn't");
        }
    }
}

