/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.functionaltests.pages;

import org.nuxeo.functionaltests.AjaxRequestManager;
import org.nuxeo.functionaltests.Locator;
import org.nuxeo.functionaltests.Required;
import org.nuxeo.functionaltests.pages.CollectionsPage;
import org.nuxeo.functionaltests.pages.DocumentBasePage;
import org.nuxeo.functionaltests.pages.UsersGroupsHomePage;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;

public class HomePage
extends DocumentBasePage {
    static final String USERS_GROUPS_LABEL = "Users & Groups";
    static final String COLLECTIONS_LABEL = "Collections";
    static final String SEARCHES_LABEL = "Searches";
    @Required
    @FindBy(id="nxw_homeTabs_panel")
    protected WebElement menu;

    public HomePage(WebDriver driver) {
        super(driver);
    }

    public UsersGroupsHomePage goToUsersGroupsHomePage() {
        this.goTo(USERS_GROUPS_LABEL);
        return this.asPage(UsersGroupsHomePage.class);
    }

    public CollectionsPage goToCollections() {
        this.goTo(COLLECTIONS_LABEL);
        return this.asPage(CollectionsPage.class);
    }

    public HomePage goToSavedSearches() {
        this.goTo(SEARCHES_LABEL);
        return this.asPage(HomePage.class);
    }

    public void goTo(String tabLabel) {
        if (this.useAjaxTabs()) {
            AjaxRequestManager arm = new AjaxRequestManager(this.driver);
            arm.begin();
            Locator.findElementWaitUntilEnabledAndClick(this.menu, By.linkText((String)tabLabel));
            arm.end();
        } else {
            Locator.findElementWaitUntilEnabledAndClick(this.menu, By.linkText((String)tabLabel));
        }
    }
}

