/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.functionaltests.pages;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.functionaltests.Locator;
import org.nuxeo.functionaltests.Required;
import org.nuxeo.functionaltests.forms.Select2WidgetElement;
import org.nuxeo.functionaltests.fragment.WebFragmentImpl;
import org.nuxeo.functionaltests.pages.AbstractPage;
import org.nuxeo.functionaltests.pages.tabs.SummaryTabSubPage;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;

public class WorkflowHomePage
extends AbstractPage {
    protected static final Log log = LogFactory.getLog(WorkflowHomePage.class);
    @Required
    @FindBy(xpath="//div[contains(@id, 'cv_user_open_tasks_nxw_current_user_open_tasks_resultsPanel')]")
    protected WebElement userTasksPanel;
    @Required
    @FindBy(id="nxl_userOpenTasksLayout:nxw_contentViewActions_refreshContentView_form:nxw_contentViewActions_refreshContentView")
    protected WebElement refreshTask;
    @Required
    @FindBy(linkText="Workflow")
    public WebElement workflowLink;

    public WorkflowHomePage(WebDriver driver) {
        super(driver);
    }

    public boolean taskExistsOnTasksDashboard(String taskName) {
        WebElement taskNameEl = Locator.findElementWithTimeout(By.xpath((String)"//span[contains(@id, 'nxw_routing_task_name')]"), this.userTasksPanel);
        return taskName.equals(taskNameEl.getText());
    }

    public boolean taskDisplaysDocumentOnTasksDashboard(String docTitle) {
        WebElement targetDocumentTd = Locator.findElementWithTimeout(By.xpath((String)("//td[contains(text(), '" + docTitle + "')]")), this.userTasksPanel);
        return targetDocumentTd != null;
    }

    public void processFirstTask() {
        WebElement processButton = this.userTasksPanel.findElement(By.xpath((String)"//input[@type='submit' and @value='Process']"));
        WorkflowHomePage.waitUntilEnabledAndClick(processButton);
    }

    public SummaryTabSubPage redirectToTask(String taskTitle) {
        WorkflowHomePage.findElementWaitUntilEnabledAndClick(By.linkText((String)taskTitle));
        return new SummaryTabSubPage(this.driver);
    }

    public boolean isTasksDashboardEmpty() {
        return !this.userTasksPanel.getText().contains("Task Name");
    }

    public void reassignTask(String taskDirective, String user) {
        TaskFancyBoxFragment taskBox = this.showTaskFancyBox("Reassign Task");
        taskBox.waitForTextToBePresent(taskDirective);
        Select2WidgetElement particpants = new Select2WidgetElement(this.driver, this.driver.findElement(By.xpath((String)"//div[contains(@id, 'nxl_workflowTaskReassignmentLayout_1:nxw_task_reassignment_actors_1_select2')]")), true);
        particpants.selectValue(user);
        taskBox.submit();
    }

    public void delegateTask(String taskDirective, String user) {
        TaskFancyBoxFragment taskBox = this.showTaskFancyBox("Delegate Task");
        taskBox.waitForTextToBePresent(taskDirective);
        Select2WidgetElement particpants = new Select2WidgetElement(this.driver, this.driver.findElement(By.xpath((String)"//div[contains(@id, 'nxl_workflowTaskReassignmentLayout:nxw_task_reassignment_actors_select2')]")), true);
        particpants.selectValue(user);
        taskBox.submit();
    }

    public TaskFancyBoxFragment showTaskFancyBox(String taskAction) {
        WorkflowHomePage.findElementWaitUntilEnabledAndClick(By.xpath((String)String.format("//input[@type='submit' and @value='%s']", taskAction)));
        WebElement element = AbstractPage.getFancyBoxContent();
        return this.getWebFragment(element, TaskFancyBoxFragment.class);
    }

    public static class TaskFancyBoxFragment
    extends WebFragmentImpl {
        @FindBy(xpath="//div[@id='fancybox-content']//input[@value='Cancel']")
        public WebElement cancelButton;
        @FindBy(xpath="//div[@id='fancybox-content']//input[@type='submit']")
        public WebElement sumbitButton;

        public TaskFancyBoxFragment(WebDriver driver, WebElement element) {
            super(driver, element);
        }

        public void cancel() {
            Locator.waitUntilEnabledAndClick(this.cancelButton);
            AbstractPage.waitForFancyBoxClosed();
        }

        @Override
        public void submit() {
            Locator.waitUntilEnabledAndClick(this.sumbitButton);
            AbstractPage.waitForFancyBoxClosed();
        }
    }
}

