/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.functionaltests.pages.admincenter.usermanagement;

import java.util.List;
import java.util.stream.Collectors;
import org.nuxeo.functionaltests.AjaxRequestManager;
import org.nuxeo.functionaltests.Locator;
import org.nuxeo.functionaltests.Required;
import org.nuxeo.functionaltests.forms.Select2WidgetElement;
import org.nuxeo.functionaltests.pages.admincenter.usermanagement.GroupViewTabSubPage;
import org.nuxeo.functionaltests.pages.admincenter.usermanagement.UsersGroupsBasePage;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;

public class GroupEditFormPage
extends UsersGroupsBasePage {
    @Required
    @FindBy(id="viewGroupView:editGroup:nxl_group:nxw_group_label")
    WebElement labelInput;
    @Required
    @FindBy(id="s2id_viewGroupView:editGroup:nxl_group:nxw_group_members_select2")
    WebElement membersSelect;
    @Required
    @FindBy(id="s2id_viewGroupView:editGroup:nxl_group:nxw_group_subgroups_select2")
    WebElement subgroupsSelect;
    @Required
    @FindBy(xpath="//input[@value=\"Save\"]")
    WebElement saveButton;

    public GroupEditFormPage(WebDriver driver) {
        super(driver);
    }

    public void setLabel(String label) {
        this.labelInput.clear();
        this.labelInput.sendKeys(new CharSequence[]{label});
    }

    public List<String> getMembers() {
        return new Select2WidgetElement(this.driver, this.membersSelect, true).getSelectedValues().stream().map(WebElement::getText).collect(Collectors.toList());
    }

    public GroupEditFormPage setMembers(String ... members) {
        new Select2WidgetElement(this.driver, this.membersSelect, true).selectValues(members);
        return this.asPage(GroupEditFormPage.class);
    }

    public GroupEditFormPage addMember(String member) {
        new Select2WidgetElement(this.driver, this.membersSelect, true).selectValue(member);
        return this.asPage(GroupEditFormPage.class);
    }

    public List<String> getSubGroups() {
        return new Select2WidgetElement(this.driver, this.subgroupsSelect, true).getSelectedValues().stream().map(WebElement::getText).collect(Collectors.toList());
    }

    public GroupEditFormPage setSubGroups(String ... subGroups) {
        new Select2WidgetElement(this.driver, this.subgroupsSelect, true).selectValues(subGroups);
        return this.asPage(GroupEditFormPage.class);
    }

    public GroupViewTabSubPage save() {
        AjaxRequestManager arm = new AjaxRequestManager(this.driver);
        arm.begin();
        Locator.waitUntilEnabledAndClick(this.saveButton);
        arm.end();
        return this.asPage(GroupViewTabSubPage.class);
    }
}

