/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.functionaltests.pages.admincenter.usermanagement;

import org.nuxeo.functionaltests.AjaxRequestManager;
import org.nuxeo.functionaltests.Required;
import org.nuxeo.functionaltests.pages.admincenter.usermanagement.GroupCreationFormPage;
import org.nuxeo.functionaltests.pages.admincenter.usermanagement.GroupViewTabSubPage;
import org.nuxeo.functionaltests.pages.admincenter.usermanagement.UsersGroupsBasePage;
import org.openqa.selenium.By;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;

public class GroupsTabSubPage
extends UsersGroupsBasePage {
    @FindBy(id="groupsListingView:createGroupActionsForm:createGroupButton")
    WebElement createNewGroupLink;
    @Required
    @FindBy(id="groupsListingView:searchForm:searchText")
    WebElement searchInput;
    @Required
    @FindBy(id="groupsListingView:searchForm:searchButton")
    WebElement searchButton;

    public GroupsTabSubPage(WebDriver driver) {
        super(driver);
    }

    public GroupCreationFormPage getGroupCreatePage() {
        this.createNewGroupLink.click();
        return this.asPage(GroupCreationFormPage.class);
    }

    public GroupsTabSubPage searchGroup(String query) {
        this.searchInput.clear();
        this.searchInput.sendKeys(new CharSequence[]{query});
        AjaxRequestManager arm = new AjaxRequestManager(this.driver);
        arm.begin();
        this.searchButton.click();
        arm.end();
        return this.asPage(GroupsTabSubPage.class);
    }

    public boolean isGroupFound(String groupname) {
        try {
            this.findElementWithTimeout(By.linkText((String)groupname), 2000);
        }
        catch (NoSuchElementException e) {
            return false;
        }
        return true;
    }

    public GroupViewTabSubPage viewGroup(String groupname) {
        GroupsTabSubPage.findElementWithTimeout(By.linkText((String)groupname)).click();
        return this.asPage(GroupViewTabSubPage.class);
    }
}

