/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.functionaltests.pages.forms;

import org.nuxeo.functionaltests.Locator;
import org.nuxeo.functionaltests.Required;
import org.nuxeo.functionaltests.forms.Select2WidgetElement;
import org.nuxeo.functionaltests.pages.AbstractPage;
import org.nuxeo.functionaltests.pages.tabs.TopicTabSubPage;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;

public class TopicCreationFormPage
extends AbstractPage {
    @Required
    @FindBy(xpath="//input[@id='createThread:title']")
    public WebElement titleTextInput;
    @FindBy(xpath="//textarea[@id='createThread:description']")
    public WebElement descriptionTextInput;
    @Required
    @FindBy(xpath="//input[@type='radio' and @value='true']")
    public WebElement moderationYesRadioButton;
    @Required
    @FindBy(xpath="//input[@type='radio' and @value='false']")
    public WebElement moderationNoRadioButton;
    @Required
    @FindBy(xpath="//input[@type='submit' and @value='Create']")
    public WebElement createButton;
    @Required
    @FindBy(xpath="//input[@type='submit' and @value='Cancel']")
    public WebElement cancelButton;

    public TopicCreationFormPage(WebDriver driver) {
        super(driver);
    }

    public TopicTabSubPage createTopicDocument(String title, String description, Boolean moderation, String ... usersOrGroups) {
        this.titleTextInput.sendKeys(new CharSequence[]{title});
        this.descriptionTextInput.sendKeys(new CharSequence[]{description});
        if (moderation.booleanValue()) {
            Locator.scrollAndForceClick(this.moderationYesRadioButton);
        } else {
            Locator.scrollAndForceClick(this.moderationNoRadioButton);
        }
        if (usersOrGroups != null) {
            Select2WidgetElement selectUsersOrGroups = new Select2WidgetElement(this.driver, this.driver.findElement(By.xpath((String)"//div[@id='s2id_createThread:nxl_user_group_prefixed_suggestion:nxw_selection_select2']")), true);
            selectUsersOrGroups.selectValues(usersOrGroups);
        }
        Locator.waitUntilEnabledAndClick(this.createButton);
        return this.asPage(TopicTabSubPage.class);
    }
}

