/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.functionaltests.pages.tabs;

import java.util.List;
import org.nuxeo.functionaltests.AbstractTest;
import org.nuxeo.functionaltests.contentView.ContentViewElement;
import org.nuxeo.functionaltests.pages.DocumentBasePage;
import org.openqa.selenium.By;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;

public abstract class AbstractContentTabSubPage
extends DocumentBasePage {
    @Deprecated
    @FindBy(id="cv_document_content_0_quickFilterForm:nxl_document_content_filter:nxw_search_title")
    WebElement filterInput;
    @Deprecated
    @FindBy(id="cv_document_content_0_quickFilterForm:submitFilter")
    WebElement filterButton;
    @Deprecated
    @FindBy(id="cv_document_content_0_resetFilterForm:resetFilter")
    WebElement clearFilterButton;

    public AbstractContentTabSubPage(WebDriver driver) {
        super(driver);
    }

    protected abstract WebElement getContentViewElement();

    public ContentViewElement getContentView() {
        return AbstractTest.getWebFragment(this.getContentViewElement(), ContentViewElement.class);
    }

    public List<WebElement> getChildDocumentRows() {
        return this.getContentView().getItems();
    }

    public boolean hasDocumentLink(String title) {
        try {
            WebElement element = this.getContentView().findElement(By.linkText((String)title));
            return element != null;
        }
        catch (NoSuchElementException e) {
            return false;
        }
    }

    public DocumentBasePage goToDocument(String documentTitle) {
        this.getContentView().clickOnItemTitle(documentTitle);
        return this.asPage(DocumentBasePage.class);
    }

    public DocumentBasePage goToDocumentWithVersion(String title, String version) {
        this.getContentView().clickOnItemTitleAndVersion(title, version);
        return this.asPage(DocumentBasePage.class);
    }

    public DocumentBasePage goToDocument(int index) {
        this.getContentView().clickOnItemIndex(index);
        return this.asPage(DocumentBasePage.class);
    }

    public DocumentBasePage filterDocument(String filter) {
        return this.filterDocument(filter, DocumentBasePage.class);
    }

    public <T extends DocumentBasePage> T filterDocument(String filter, Class<T> pageClassToProxy) {
        this.getContentView().filterDocument(filter);
        return (T)((DocumentBasePage)this.asPage(pageClassToProxy));
    }

    public DocumentBasePage clearFilter() {
        return this.clearFilter(DocumentBasePage.class);
    }

    public <T extends DocumentBasePage> T clearFilter(Class<T> pageClassToProxy) {
        this.getContentView().clearFilter();
        return (T)((DocumentBasePage)this.asPage(pageClassToProxy));
    }

    public DocumentBasePage removeDocument(String documentTitle) {
        return this.getContentView().selectByTitle(documentTitle).delete();
    }

    public <T extends DocumentBasePage> T removeDocument(String documentTitle, Class<T> pageClassToProxy) {
        return (T)((DocumentBasePage)this.getContentView().selectByTitle(documentTitle).delete(pageClassToProxy));
    }

    public DocumentBasePage removeAllDocuments() {
        return this.removeAllDocuments(DocumentBasePage.class);
    }

    public <T extends DocumentBasePage> T removeAllDocuments(Class<T> pageClassToProxy) {
        ContentViewElement cv = this.getContentView();
        if (cv.getItems().size() == 0) {
            if (pageClassToProxy.isInstance(this)) {
                return (T)this;
            }
            return null;
        }
        return (T)((DocumentBasePage)this.getContentView().selectAll().delete(pageClassToProxy));
    }
}

