/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.functionaltests.pages.tabs;

import org.apache.commons.lang3.StringUtils;
import org.junit.Assert;
import org.nuxeo.functionaltests.Required;
import org.nuxeo.functionaltests.pages.DocumentBasePage;
import org.openqa.selenium.By;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;

public class TopicTabSubPage
extends DocumentBasePage {
    private static final String COMMENT_XPATH_BASE = ".//div[@class='commentAuthor' and starts-with(text(),'%s')]/..";
    public static final String COMMENT_STATUS_PUBLISHED = "Published";
    public static final String COMMENT_STATUS_WAITING_APPROVAL = "Waiting for approval";
    public static final String COMMENT_STATUS_REJECTED = "Rejected";
    @Required
    @FindBy(xpath="//ul[contains(@class,'commentsOutput')]")
    public WebElement commentsList;
    @FindBy(xpath="//input[contains(@id,'post_title')]")
    public WebElement titleInput;
    @FindBy(xpath="//textarea[contains(@id,'post_description')]")
    public WebElement descriptionInput;
    @FindBy(xpath="//input[@type='submit' and @value='Add']")
    public WebElement addButton;
    @FindBy(xpath="//input[@type='submit' and @value='Cancel']")
    public WebElement cancelButton;

    public TopicTabSubPage(WebDriver driver) {
        super(driver);
    }

    public void checkComment(String title, String author, String description, String status, boolean canReply, boolean canApproveOrReject, boolean canDelete) {
        WebElement comment = this.getComment(title);
        this.checkAuthor(comment, author);
        this.checkDescription(comment, description);
        this.checkStatus(comment, status);
        Assert.assertEquals((Object)canReply, (Object)this.hasReplyLink(comment));
        Assert.assertEquals((Object)canApproveOrReject, (Object)(this.hasApproveLink(comment) && this.hasRejectLink(comment) ? 1 : 0));
        Assert.assertEquals((Object)canDelete, (Object)this.hasDeleteLink(comment));
    }

    public boolean hasComment(String title) {
        try {
            return this.getComment(title) != null;
        }
        catch (NoSuchElementException e) {
            return false;
        }
    }

    public boolean isCommentFormDisplayed() {
        try {
            return this.titleInput.isDisplayed() && this.descriptionInput.isDisplayed();
        }
        catch (NoSuchElementException e) {
            return false;
        }
    }

    public TopicTabSubPage showCommentForm() {
        if (!this.isCommentFormDisplayed()) {
            this.addButton.click();
            return this.asPage(TopicTabSubPage.class);
        }
        return this;
    }

    public TopicTabSubPage addComment(String title, String description) {
        if (StringUtils.isNotBlank((CharSequence)title)) {
            this.titleInput.sendKeys(new CharSequence[]{title});
        }
        if (description != null) {
            this.descriptionInput.sendKeys(new CharSequence[]{description});
        }
        this.addButton.click();
        return this.asPage(TopicTabSubPage.class);
    }

    public TopicTabSubPage reply(String title, String description) {
        this.getReplyLink(this.getComment(title)).click();
        TopicTabSubPage page = this.asPage(TopicTabSubPage.class);
        return page.addComment(null, description);
    }

    public TopicTabSubPage delete(String title) {
        this.getDeleteLink(this.getComment(title)).click();
        return this.asPage(TopicTabSubPage.class);
    }

    public TopicTabSubPage reject(String title) {
        this.getRejectLink(this.getComment(title)).click();
        return this.asPage(TopicTabSubPage.class);
    }

    public TopicTabSubPage approve(String title) {
        this.getApproveLink(this.getComment(title)).click();
        return this.asPage(TopicTabSubPage.class);
    }

    public WebElement getComment(String title) {
        String xpath = String.format(COMMENT_XPATH_BASE, title);
        return this.commentsList.findElement(By.xpath((String)xpath));
    }

    private WebElement getReplyLink(WebElement comment) {
        return comment.findElement(By.linkText((String)"Reply"));
    }

    private WebElement getApproveLink(WebElement comment) {
        return comment.findElement(By.linkText((String)"Approve"));
    }

    private WebElement getRejectLink(WebElement comment) {
        return comment.findElement(By.linkText((String)"Reject"));
    }

    private WebElement getDeleteLink(WebElement comment) {
        return comment.findElement(By.linkText((String)"Delete"));
    }

    private boolean hasReplyLink(WebElement comment) {
        try {
            return this.getReplyLink(comment) != null;
        }
        catch (NoSuchElementException e) {
            return false;
        }
    }

    private boolean hasApproveLink(WebElement comment) {
        try {
            return this.getApproveLink(comment) != null;
        }
        catch (NoSuchElementException e) {
            return false;
        }
    }

    private boolean hasRejectLink(WebElement comment) {
        try {
            return this.getRejectLink(comment) != null;
        }
        catch (NoSuchElementException e) {
            return false;
        }
    }

    private boolean hasDeleteLink(WebElement comment) {
        try {
            return this.getDeleteLink(comment) != null;
        }
        catch (NoSuchElementException e) {
            return false;
        }
    }

    private void checkAuthor(WebElement comment, String author) {
        Assert.assertTrue((boolean)comment.findElement(By.className((String)"commentAuthor")).getText().contains("by " + author));
    }

    private void checkDescription(WebElement comment, String description) {
        Assert.assertTrue((boolean)comment.findElement(By.className((String)"commentQuote")).getText().equals(description));
    }

    private void checkStatus(WebElement comment, String status) {
        Assert.assertTrue((boolean)comment.findElement(By.className((String)"commentCreationDate")).getText().contains(status));
    }
}

