/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.functionaltests.pages.tabs;

import java.util.List;
import org.junit.Assert;
import org.nuxeo.functionaltests.AbstractTest;
import org.nuxeo.functionaltests.AjaxRequestManager;
import org.nuxeo.functionaltests.Required;
import org.nuxeo.functionaltests.contentView.ContentViewElement;
import org.nuxeo.functionaltests.pages.AbstractPage;
import org.nuxeo.functionaltests.pages.DocumentBasePage;
import org.openqa.selenium.Alert;
import org.openqa.selenium.By;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;

public class TrashSubPage
extends AbstractPage {
    protected static final String SELECT_ALL_BUTTON_ID = "document_trash_content:nxl_document_listing_table:listing_table_selection_box_with_current_document_header";
    protected static final String PERMANENT_DELETE_BUTTON_ID = "document_trash_content_buttons:nxw_CURRENT_SELECTION_DELETE_form:nxw_CURRENT_SELECTION_DELETE";
    protected static final String RESTORE_BUTTON_ID = "document_trash_content_buttons:nxw_CURRENT_SELECTION_UNDELETE_form:nxw_CURRENT_SELECTION_UNDELETE";
    protected static final String EMPTY_TRASH_BUTTON_ID = "document_trash_content_buttons:nxw_CURRENT_SELECTION_EMPTY_TRASH_form:nxw_CURRENT_SELECTION_EMPTY_TRASH";
    @FindBy(xpath="//form[@id=\"document_trash_content\"]//tbody//tr")
    List<WebElement> childDocumentRows;
    @Required
    @FindBy(id="cv_document_trash_content_0_resultsPanel")
    protected WebElement documentContentForm;

    public List<WebElement> getChildDocumentRows() {
        return this.childDocumentRows;
    }

    public TrashSubPage(WebDriver driver) {
        super(driver);
    }

    public TrashSubPage emptyTrash() {
        TrashSubPage.findElementWaitUntilEnabledAndClick(By.id((String)EMPTY_TRASH_BUTTON_ID));
        Alert alert = this.driver.switchTo().alert();
        Assert.assertEquals((Object)"Permanently delete all documents in trash?", (Object)alert.getText());
        alert.accept();
        return this.asPage(TrashSubPage.class);
    }

    public TrashSubPage purgeAllDocuments() {
        TrashSubPage page = this.asPage(TrashSubPage.class);
        By locator = By.id((String)SELECT_ALL_BUTTON_ID);
        if (!this.hasElement(locator)) {
            return page;
        }
        AjaxRequestManager arm = new AjaxRequestManager(this.driver);
        arm.begin();
        TrashSubPage.findElementWaitUntilEnabledAndClick(By.id((String)SELECT_ALL_BUTTON_ID));
        arm.end();
        this.deleteSelectedDocuments();
        return this.asPage(TrashSubPage.class);
    }

    public TrashSubPage goToDocument(int index) {
        this.getChildDocumentRows().get(index).findElement(By.xpath((String)"td[3]/div/a[1]")).click();
        return this.asPage(TrashSubPage.class);
    }

    public TrashSubPage goToDocument(String documentTitle) {
        this.getElement().clickOnItemTitle(documentTitle);
        return this.asPage(TrashSubPage.class);
    }

    public TrashSubPage selectByTitle(String ... titles) {
        AjaxRequestManager arm = new AjaxRequestManager(this.driver);
        arm.begin();
        this.getElement().checkByTitle(titles);
        arm.end();
        return this.asPage(TrashSubPage.class);
    }

    public DocumentBasePage restoreDocument(String ... titles) {
        AjaxRequestManager arm = new AjaxRequestManager(this.driver);
        arm.begin();
        this.getElement().checkByTitle(titles);
        arm.end();
        this.restoreSelectedDocuments();
        return this.asPage(DocumentBasePage.class);
    }

    public TrashSubPage purgeDocument(String ... titles) {
        AjaxRequestManager arm = new AjaxRequestManager(this.driver);
        arm.begin();
        this.getElement().checkByTitle(titles);
        arm.end();
        this.deleteSelectedDocuments();
        return this.asPage(TrashSubPage.class);
    }

    public boolean hasDocumentLink(String title) {
        try {
            WebElement element = this.documentContentForm.findElement(By.linkText((String)title));
            return element != null;
        }
        catch (NoSuchElementException e) {
            return false;
        }
    }

    protected ContentViewElement getElement() {
        return AbstractTest.getWebFragment(By.id((String)"cv_document_trash_content_0_panel"), ContentViewElement.class);
    }

    protected void restoreSelectedDocuments() {
        TrashSubPage.findElementWaitUntilEnabledAndClick(By.id((String)RESTORE_BUTTON_ID));
        Alert alert = this.driver.switchTo().alert();
        Assert.assertEquals((Object)"Undelete selected document(s)?", (Object)alert.getText());
        alert.accept();
    }

    protected void deleteSelectedDocuments() {
        TrashSubPage.findElementWaitUntilEnabledAndClick(By.id((String)PERMANENT_DELETE_BUTTON_ID));
        Alert alert = this.driver.switchTo().alert();
        Assert.assertEquals((Object)"Permanently delete selected document(s)?", (Object)alert.getText());
        alert.accept();
    }
}

