/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.functionaltests.pages.wizard;

import com.google.common.base.Function;
import java.util.ArrayList;
import java.util.List;
import org.nuxeo.functionaltests.AbstractTest;
import org.nuxeo.functionaltests.pages.wizard.AbstractWizardPage;
import org.nuxeo.functionaltests.pages.wizard.ConnectWizardPage;
import org.nuxeo.functionaltests.pages.wizard.IFrameHelper;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;

public class WizardPage
extends AbstractWizardPage {
    protected static final String NEXT_BUTTON_LOCATOR = "id('btnNext')";
    protected static final String PREV_BUTTON_LOCATOR = "id('btnPrev')";

    public WizardPage(WebDriver driver) {
        super(driver);
        IFrameHelper.focusOnWizardPage(driver);
    }

    public WizardPage next() {
        return this.next(false);
    }

    public WizardPage next(Boolean errorExpected) {
        if (errorExpected.booleanValue()) {
            return this.next(WizardPage.class, (Function<WebDriver, Boolean>)((Function)driver -> this.hasError()));
        }
        return this.next(WizardPage.class);
    }

    public WizardPage previous() {
        return this.previous(false);
    }

    public WizardPage previous(Boolean errorExpected) {
        if (errorExpected.booleanValue()) {
            return this.previous(WizardPage.class, (Function<WebDriver, Boolean>)((Function)driver -> this.hasError()));
        }
        return this.previous(WizardPage.class);
    }

    @Override
    protected By getNextButtonLocator() {
        return By.xpath((String)NEXT_BUTTON_LOCATOR);
    }

    @Override
    protected By getPreviousButtonLocator() {
        return By.xpath((String)PREV_BUTTON_LOCATOR);
    }

    public ConnectWizardPage getConnectPage() {
        AbstractTest.switchToPopup("/register/#/embedded");
        return AbstractTest.asPage(ConnectWizardPage.class);
    }

    public boolean hasError() {
        return this.getErrors().size() > 0;
    }

    public List<String> getErrors() {
        List errorsEl = this.driver.findElements(By.xpath((String)"//div[@class='errBlock']/div[@class='errItem']"));
        ArrayList<String> errors = new ArrayList<String>();
        for (WebElement errorEl : errorsEl) {
            if (errorEl.getText() == null || errorEl.getText().length() <= 0) continue;
            errors.add(errorEl.getText());
        }
        return errors;
    }

    public List<String> getInfos() {
        List infosEl = this.driver.findElements(By.xpath((String)"//div[@class='infoBlock']/div[@class='infoItem']"));
        ArrayList<String> infos = new ArrayList<String>();
        for (WebElement infoEl : infosEl) {
            if (infoEl.getText() == null || infoEl.getText().length() <= 0) continue;
            infos.add(infoEl.getText());
        }
        return infos;
    }

    public boolean hasInfo() {
        return this.getInfos().size() > 0;
    }

    public String getTagText(String tag) {
        WebElement tagElt = WizardPage.findElementWithTimeout(By.xpath((String)("//" + tag)));
        if (tagElt == null) {
            return null;
        }
        return tagElt.getText();
    }
}

