/*
 * (C) Copyright 2017 Nuxeo (http://nuxeo.com/) and others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Contributors:
 *     Funsho David
 *
 */

package org.nuxeo.functionaltests.shibboleth;

import org.nuxeo.functionaltests.AbstractTest;
import org.nuxeo.functionaltests.pages.shibboleth.ShibbolethLoginPage;

/**
 * @since 9.10
 */
public class ShibbolethTest extends AbstractTest {

    protected static final String SHIB_TEST_USER = "nuxeotest";

    protected static final String SHIB_TEST_PASSWORD = "password";

    protected ShibbolethLoginPage loginAsShibbolethUser(String url, String username, String password) {
        ShibbolethLoginPage loginPage = get(url, ShibbolethLoginPage.class);
        loginPage.login(username, password);
        return loginPage;
    }

}
