/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.schema;

import java.util.ArrayList;
import java.util.Arrays;
import org.apache.commons.lang3.StringUtils;
import org.nuxeo.common.xmap.annotation.XNode;
import org.nuxeo.common.xmap.annotation.XNodeList;
import org.nuxeo.common.xmap.annotation.XObject;
import org.nuxeo.ecm.core.schema.SchemaDescriptor;

@XObject(value="doctype")
public class DocumentTypeDescriptor {
    @XNode(value="@name")
    public String name;
    @XNodeList(value="schema", type=SchemaDescriptor[].class, componentType=SchemaDescriptor.class)
    public SchemaDescriptor[] schemas;
    @XNode(value="@extends")
    public String superTypeName;
    @XNodeList(value="facet@name", type=String[].class, componentType=String.class)
    public String[] facets;
    @XNode(value="prefetch")
    public String prefetch;
    @XNode(value="@append")
    public boolean append = false;
    @XNode(value="@special")
    public Boolean special;
    @XNodeList(value="subtypes/type", type=String[].class, componentType=String.class)
    public String[] subtypes = new String[0];
    @XNodeList(value="subtypes-forbidden/type", type=String[].class, componentType=String.class)
    public String[] forbiddenSubtypes = new String[0];

    public DocumentTypeDescriptor() {
    }

    public DocumentTypeDescriptor(String superTypeName, String name, SchemaDescriptor[] schemas, String[] facets) {
        this.name = name;
        this.superTypeName = superTypeName;
        this.schemas = schemas;
        this.facets = facets;
    }

    public DocumentTypeDescriptor(String superTypeName, String name, SchemaDescriptor[] schemas, String[] facets, String[] subtypes, String[] forbiddenSubtypes) {
        this(superTypeName, name, schemas, facets);
        this.subtypes = subtypes;
        this.forbiddenSubtypes = forbiddenSubtypes;
    }

    public String toString() {
        return "DocType: " + this.name;
    }

    public DocumentTypeDescriptor clone() {
        DocumentTypeDescriptor clone = new DocumentTypeDescriptor();
        clone.name = this.name;
        clone.schemas = this.schemas;
        clone.superTypeName = this.superTypeName;
        clone.facets = this.facets;
        clone.prefetch = this.prefetch;
        clone.append = this.append;
        clone.special = this.special;
        clone.subtypes = this.subtypes;
        clone.forbiddenSubtypes = this.forbiddenSubtypes;
        return clone;
    }

    public DocumentTypeDescriptor merge(DocumentTypeDescriptor other) {
        ArrayList<String> mergedTypes;
        if (this.schemas == null) {
            this.schemas = other.schemas;
        } else if (other.schemas != null) {
            ArrayList<SchemaDescriptor> mergedSchemas = new ArrayList<SchemaDescriptor>(Arrays.asList(this.schemas));
            mergedSchemas.addAll(Arrays.asList(other.schemas));
            this.schemas = mergedSchemas.toArray(new SchemaDescriptor[mergedSchemas.size()]);
        }
        if (this.facets == null) {
            this.facets = other.facets;
        } else if (other.facets != null) {
            ArrayList<String> mergedFacets = new ArrayList<String>(Arrays.asList(this.facets));
            mergedFacets.addAll(Arrays.asList(other.facets));
            this.facets = mergedFacets.toArray(new String[mergedFacets.size()]);
        }
        if (this.prefetch == null) {
            this.prefetch = other.prefetch;
        } else if (other.prefetch != null) {
            this.prefetch = this.prefetch + " " + other.prefetch;
        }
        if (StringUtils.isEmpty((CharSequence)this.superTypeName) && StringUtils.isNotEmpty((CharSequence)other.superTypeName)) {
            this.superTypeName = other.superTypeName;
        }
        Boolean bl = this.special = this.special == null ? other.special : this.special;
        if (this.subtypes == null) {
            this.subtypes = other.subtypes;
        } else if (other.subtypes != null) {
            mergedTypes = new ArrayList<String>(Arrays.asList(this.subtypes));
            mergedTypes.addAll(Arrays.asList(other.subtypes));
            this.subtypes = mergedTypes.toArray(new String[mergedTypes.size()]);
        }
        if (this.forbiddenSubtypes == null) {
            this.forbiddenSubtypes = other.forbiddenSubtypes;
        } else if (other.forbiddenSubtypes != null) {
            mergedTypes = new ArrayList<String>(Arrays.asList(this.forbiddenSubtypes));
            mergedTypes.addAll(Arrays.asList(other.forbiddenSubtypes));
            this.forbiddenSubtypes = mergedTypes.toArray(new String[mergedTypes.size()]);
        }
        return this;
    }
}

