/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.schema.types.primitives;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.schema.types.PrimitiveType;
import org.nuxeo.ecm.core.schema.types.constraints.Constraint;
import org.nuxeo.ecm.core.schema.types.constraints.NotNullConstraint;

public final class BinaryType
extends PrimitiveType {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(BinaryType.class);
    public static final String ID = "binary";
    public static final BinaryType INSTANCE = new BinaryType();

    private BinaryType() {
        super(ID);
    }

    @Override
    public boolean validate(Object object) {
        return true;
    }

    @Override
    public Object convert(Object value) {
        if (value instanceof CharSequence) {
            return new ByteArrayInputStream(value.toString().getBytes());
        }
        if (value instanceof byte[]) {
            return new ByteArrayInputStream((byte[])value);
        }
        if (value instanceof InputStream) {
            return value;
        }
        return null;
    }

    public static Object parseString(String str) {
        return new ByteArrayInputStream(str.getBytes());
    }

    protected Object readResolve() {
        return INSTANCE;
    }

    @Override
    public Object decode(String str) {
        if (StringUtils.isEmpty((CharSequence)str)) {
            return null;
        }
        return new ByteArrayInputStream(str.getBytes());
    }

    @Override
    public String encode(Object object) {
        if (object instanceof InputStream) {
            String string;
            block9: {
                InputStream in = (InputStream)object;
                try {
                    string = IOUtils.toString((InputStream)in, (Charset)StandardCharsets.UTF_8);
                    if (in == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (in != null) {
                            try {
                                in.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        log.error((Object)e, (Throwable)e);
                        return null;
                    }
                }
                in.close();
            }
            return string;
        }
        return object.toString();
    }

    @Override
    public boolean support(Class<? extends Constraint> constraint) {
        return NotNullConstraint.class.equals(constraint);
    }
}

