/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.connect.connector.http;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;
import org.nuxeo.connect.connector.ConnectServerError;
import org.nuxeo.connect.connector.ConnectServerResponse;

public class ConnectHttpResponse
implements ConnectServerResponse {
    protected static final Log log = LogFactory.getLog(ConnectHttpResponse.class);
    protected CloseableHttpClient httpClient;
    protected CloseableHttpResponse httpResponse;

    public ConnectHttpResponse(CloseableHttpClient httpClient, CloseableHttpResponse httpResponse) {
        this.httpClient = httpClient;
        this.httpResponse = httpResponse;
    }

    @Override
    public InputStream getInputStream() throws ConnectServerError {
        try {
            return this.httpResponse.getEntity().getContent();
        }
        catch (IOException e) {
            throw new ConnectServerError("Unable to get Stream", e);
        }
    }

    @Override
    public String getString() throws ConnectServerError {
        try {
            HttpEntity entity = this.httpResponse.getEntity();
            return entity == null ? null : EntityUtils.toString((HttpEntity)entity);
        }
        catch (IOException e) {
            throw new ConnectServerError("Unable to ready body", e);
        }
    }

    @Override
    public void release() throws ConnectServerError {
        try {
            this.httpResponse.close();
            this.httpClient.close();
        }
        catch (IOException e) {
            throw new ConnectServerError("Unable to close connection resources", e);
        }
    }
}

