/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.core.operations.blob;

import java.io.IOException;
import java.util.Collections;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.util.BlobList;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.core.api.blobholder.SimpleBlobHolder;
import org.nuxeo.ecm.core.convert.api.ConversionService;

@Operation(id="Blob.ToPDF", category="Conversion", label="Convert To PDF", description="Convert the input file to a PDF and return the new file.")
public class BlobToPDF {
    public static final String ID = "Blob.ToPDF";
    @Context
    protected ConversionService service;

    @OperationMethod
    public Blob run(DocumentModel doc) throws IOException {
        BlobHolder bh = (BlobHolder)doc.getAdapter(BlobHolder.class);
        if (bh == null) {
            return null;
        }
        return this.service.convertToMimeType("application/pdf", bh, Collections.emptyMap()).getBlob();
    }

    @OperationMethod
    public Blob run(Blob blob) throws IOException {
        return this.service.convertToMimeType("application/pdf", (BlobHolder)new SimpleBlobHolder(blob), Collections.emptyMap()).getBlob();
    }

    @OperationMethod
    public BlobList run(BlobList blobs) throws IOException {
        BlobList bl = new BlobList();
        for (Blob blob : blobs) {
            bl.add(this.run(blob));
        }
        return bl;
    }
}

