/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.core.operations.document;

import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.automation.core.collectors.DocumentModelCollector;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.PathRef;

@Operation(id="Document.CreateLiveProxy", category="Document", label="Create Proxy Live", description="This operation will create a proxy that points the given document as input. This is like a symbolic link for File System. The proxy will be created into the destination specified as parameter. <p>The document returned is the proxy live.<p> Remark: <b>you will have a strange behavior if the input is a folderish.</b>", aliases={"CreateProxyLive"})
public class CreateProxyLive {
    public static final String ID = "Document.CreateLiveProxy";
    @Context
    protected CoreSession session;
    @Param(name="Destination Path")
    protected String path;

    @OperationMethod(collector=DocumentModelCollector.class)
    public DocumentModel run(DocumentModel input) {
        PathRef docRef = new PathRef(this.path);
        if (!this.session.exists((DocumentRef)docRef)) {
            throw new NuxeoException(String.format("Destination \"%s\" specified into operation not found", this.path));
        }
        DocumentModel proxy = this.session.createProxy(input.getRef(), (DocumentRef)docRef);
        return proxy;
    }
}

