/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.core.trace;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.automation.OperationCallback;
import org.nuxeo.ecm.automation.OperationChain;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.OperationException;
import org.nuxeo.ecm.automation.OperationType;
import org.nuxeo.ecm.automation.core.impl.InvokableMethod;
import org.nuxeo.ecm.automation.core.trace.Call;
import org.nuxeo.ecm.automation.core.trace.LiteCall;
import org.nuxeo.ecm.automation.core.trace.Trace;
import org.nuxeo.ecm.automation.core.trace.Tracer;
import org.nuxeo.ecm.automation.core.trace.TracerFactoryMBean;
import org.nuxeo.runtime.api.Framework;

public class TracerFactory
implements TracerFactoryMBean {
    public static final String AUTOMATION_TRACE_PROPERTY = "org.nuxeo.automation.trace";
    public static final String AUTOMATION_TRACE_PRINTABLE_PROPERTY = "org.nuxeo.automation.trace.printable";
    protected static final Integer CACHE_CONCURRENCY_LEVEL = 10;
    protected static final Integer CACHE_MAXIMUM_SIZE = 1000;
    protected static final Integer CACHE_TIMEOUT = 10;
    protected String printable;
    protected Function<String, Boolean> printableAssertor;
    protected Cache<String, ChainTraces> tracesCache = CacheBuilder.newBuilder().concurrencyLevel(CACHE_CONCURRENCY_LEVEL.intValue()).maximumSize((long)CACHE_MAXIMUM_SIZE.intValue()).expireAfterWrite((long)CACHE_TIMEOUT.intValue(), TimeUnit.MINUTES).build();
    protected boolean recording = Framework.isBooleanPropertyTrue((String)"org.nuxeo.automation.trace");
    protected Trace lastError;

    public TracerFactory() {
        this.setPrintableTraces(Framework.getProperty((String)AUTOMATION_TRACE_PRINTABLE_PROPERTY, (String)"*"));
    }

    public OperationCallback newTracer() {
        return new Tracer(this);
    }

    public Call newCall(OperationType chain, OperationContext context, OperationType type, InvokableMethod method, Map<String, Object> params) {
        if (!this.recording) {
            return new LiteCall(chain, type);
        }
        return new Call(chain, context, type, method, params);
    }

    public Trace newTrace(Call parent, OperationType typeof, List<Call> calls, Object output, OperationException error) {
        return new Trace(parent, typeof, calls, calls.get((int)0).details.input, output, error);
    }

    protected void recordTrace(Trace trace) {
        String chainId = trace.chain.getId();
        ChainTraces chainTraces = (ChainTraces)this.tracesCache.getIfPresent((Object)chainId);
        if (chainTraces == null) {
            this.tracesCache.put((Object)chainId, (Object)new ChainTraces(trace.chain));
        }
        if (trace.getError() != null) {
            this.lastError = trace;
        }
        if ((chainTraces = (ChainTraces)this.tracesCache.getIfPresent((Object)chainId)).size() != 0) {
            chainTraces.removeTrace(1);
        }
        ((ChainTraces)this.tracesCache.getIfPresent((Object)chainId)).add(trace);
    }

    public Trace getTrace(OperationChain chain, int index) {
        return ((ChainTraces)this.tracesCache.getIfPresent((Object)chain.getId())).getTrace(index);
    }

    public Trace getTrace(String key) {
        return this.getTrace(key, -1);
    }

    public Trace getTrace(String key, int index) {
        ChainTraces chainTrace = (ChainTraces)this.tracesCache.getIfPresent((Object)key);
        if (chainTrace == null) {
            return null;
        }
        if (index < 0) {
            index = chainTrace.traces.size() - 1;
        }
        return ((ChainTraces)this.tracesCache.getIfPresent((Object)key)).getTrace(index);
    }

    public Trace getLastErrorTrace() {
        return this.lastError;
    }

    public void clearTrace(OperationChain chain, int index) {
        ((ChainTraces)this.tracesCache.getIfPresent((Object)chain)).removeTrace(index);
    }

    public void clearTrace(OperationChain chain) {
        this.tracesCache.invalidate((Object)chain);
    }

    @Override
    public void clearTraces() {
        this.tracesCache.invalidateAll();
    }

    protected static String formatKey(OperationType chain, int index) {
        return String.format("%s:%s", chain.getId(), index);
    }

    public void onTrace(Trace trace) {
        boolean containsError;
        boolean bl = containsError = trace.error != null;
        if (!this.recording && !containsError) {
            return;
        }
        if (containsError) {
            trace.error.addSuppressed(new Throwable(this.print(trace)));
        }
        if (this.printableAssertor.apply(trace.chain.getId()).booleanValue()) {
            Log log = LogFactory.getLog(Trace.class);
            if (containsError) {
                log.warn((Object)this.print(trace));
            } else {
                log.info((Object)this.print(trace));
            }
        }
        this.recordTrace(trace);
    }

    @Override
    public boolean toggleRecording() {
        this.recording = !this.recording;
        return this.recording;
    }

    @Override
    public boolean getRecordingState() {
        return this.recording;
    }

    @Override
    public String getPrintableTraces() {
        return this.printable;
    }

    @Override
    public String setPrintableTraces(String option) {
        if ("*".equals(option)) {
            this.printableAssertor = s -> Boolean.TRUE;
        } else {
            List<String> patterns = Arrays.asList(option.split(","));
            this.printableAssertor = s -> patterns.contains(s);
        }
        this.printable = option;
        return this.printable;
    }

    public String print(Trace trace) {
        return trace.print(!this.recording);
    }

    protected static class ChainTraces {
        protected OperationType chain;
        protected Map<Integer, Trace> traces = new HashMap<Integer, Trace>();

        protected ChainTraces(OperationType chain) {
            this.chain = chain;
        }

        protected String add(Trace trace) {
            int index = this.traces.size();
            this.traces.put(index, trace);
            return TracerFactory.formatKey(trace.chain, index);
        }

        protected Trace getTrace(int index) {
            return this.traces.get(index);
        }

        protected void removeTrace(int index) {
            this.traces.remove(index);
        }

        protected void clear() {
            this.traces.clear();
        }

        protected int size() {
            return this.traces.size();
        }
    }
}

