/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.rest;

import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.PathRef;
import org.nuxeo.ecm.core.rest.DocumentObject;
import org.nuxeo.ecm.core.rest.DocumentRoot;
import org.nuxeo.ecm.webengine.model.WebContext;

public class DocumentFactory {
    private DocumentFactory() {
    }

    public static DocumentObject newDocumentRoot(WebContext ctx, String path) {
        return new DocumentRoot(ctx, path);
    }

    public static DocumentObject newDocumentRoot(WebContext ctx, DocumentRef ref) {
        return new DocumentRoot(ctx, ref);
    }

    public static DocumentObject newDocumentRoot(WebContext ctx, DocumentModel doc) {
        return new DocumentRoot(ctx, doc);
    }

    public static DocumentObject newDocument(WebContext ctx, String path) {
        PathRef pathRef = new PathRef(path);
        DocumentModel doc = ctx.getCoreSession().getDocument((DocumentRef)pathRef);
        return (DocumentObject)ctx.newObject(doc.getType(), new Object[]{doc});
    }

    public static DocumentObject newDocument(WebContext ctx, DocumentRef ref) {
        DocumentModel doc = ctx.getCoreSession().getDocument(ref);
        return (DocumentObject)ctx.newObject(doc.getType(), new Object[]{doc});
    }

    public static DocumentObject newDocument(WebContext ctx, DocumentModel doc) {
        return (DocumentObject)ctx.newObject(doc.getType(), new Object[]{doc});
    }
}

