/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.pdf.operations;

import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.platform.pdf.PDFPageExtractor;

@Operation(id="PDF.ExtractPages", category="Conversion", label="PDF: Extract Pages", description="Extract pages from <code>startPage</code> to <code>endPage</code> (inclusive) from the input object. If a Blob is used as input, the <code>xpath</xpath> parameter is not used. <code>title</code>, <code>subject</code> and <code>author</code> are optional. If the PDF is encrypted, a password is required.")
public class PDFExtractPagesOperation {
    public static final String ID = "PDF.ExtractPages";
    @Context
    protected CoreSession session;
    @Param(name="startPage")
    protected long startPage;
    @Param(name="endPage")
    protected long endPage;
    @Param(name="fileName", required=false)
    protected String fileName = "";
    @Param(name="pdfTitle", required=false)
    protected String pdfTitle = "";
    @Param(name="pdfSubject", required=false)
    protected String pdfSubject;
    @Param(name="pdfAuthor", required=false)
    protected String pdfAuthor = "";
    @Param(name="xpath", required=false, values={"file:content"})
    protected String xpath = "";
    @Param(name="password", required=false)
    protected String password = null;

    @OperationMethod
    public Blob run(Blob inBlob) {
        PDFPageExtractor pe = new PDFPageExtractor(inBlob);
        pe.setPassword(this.password);
        return pe.extract((int)this.startPage, (int)this.endPage, this.fileName, this.pdfTitle, this.pdfSubject, this.pdfAuthor);
    }

    @OperationMethod
    public Blob run(DocumentModel inDoc) {
        PDFPageExtractor pe = new PDFPageExtractor(inDoc, this.xpath);
        pe.setPassword(this.password);
        return pe.extract((int)this.startPage, (int)this.endPage, this.fileName, this.pdfTitle, this.pdfSubject, this.pdfAuthor);
    }
}

