/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.pdf.operations;

import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.automation.core.util.BlobList;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.platform.pdf.PDFEncryption;

@Operation(id="PDF.RemoveEncryption", category="Conversion", label="PDF: Remove Encryption", description="Removes the encryption, returns a copy of the blob. If the operation is ran on Document(s), xpath lets you specificy where to get the blob from (default: file:content).")
public class PDFRemoveEncryptionOperation {
    public static final String ID = "PDF.RemoveEncryption";
    @Param(name="ownerPwd", required=false)
    private String ownerPwd;
    @Param(name="xpath", required=false, values={"file:content"})
    protected String xpath = "file:content";

    @OperationMethod
    public Blob run(Blob inBlob) {
        PDFEncryption pdfe = new PDFEncryption(inBlob);
        pdfe.setOriginalOwnerPwd(this.ownerPwd);
        return pdfe.removeEncryption();
    }

    @OperationMethod
    public BlobList run(BlobList inBlobs) {
        return inBlobs.stream().map(this::run).collect(Collectors.toCollection(BlobList::new));
    }

    @OperationMethod
    public Blob run(DocumentModel inDoc) {
        Blob content;
        if (StringUtils.isBlank((CharSequence)this.xpath)) {
            this.xpath = "file:content";
        }
        return (content = (Blob)inDoc.getPropertyValue(this.xpath)) != null ? this.run(content) : null;
    }

    @OperationMethod
    public BlobList run(DocumentModelList inDocs) {
        if (StringUtils.isBlank((CharSequence)this.xpath)) {
            this.xpath = "file:content";
        }
        return inDocs.stream().map(this::run).collect(Collectors.toCollection(BlobList::new));
    }
}

