/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.deployment.preprocessor.template;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import org.apache.commons.io.Charsets;
import org.apache.commons.io.IOUtils;
import org.nuxeo.runtime.deployment.preprocessor.template.Template;

public class TemplateParser {
    private TemplateParser() {
    }

    public static Template parse(File file) throws IOException {
        try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(file));){
            Template template = TemplateParser.parse(in);
            return template;
        }
    }

    public static Template parse(URL url) throws IOException {
        try (BufferedInputStream in = new BufferedInputStream(url.openStream());){
            Template template = TemplateParser.parse(in);
            return template;
        }
    }

    public static Template parse(InputStream in) throws IOException {
        String s = IOUtils.toString((InputStream)in, (Charset)Charsets.UTF_8);
        return TemplateParser.parse(s.toCharArray());
    }

    public static Template parse(char[] chars) {
        Template tpl = new Template();
        StringBuilder sb = new StringBuilder();
        StringBuilder name = new StringBuilder();
        tpl.addPart("BEGIN", null);
        boolean marker = false;
        block4: for (int i = 0; i < chars.length; ++i) {
            char ch = chars[i];
            switch (ch) {
                case '%': {
                    if (i < chars.length && chars[i + 1] == '{') {
                        marker = true;
                        ++i;
                        continue block4;
                    }
                    if (marker) {
                        name.append(ch);
                        continue block4;
                    }
                    sb.append(ch);
                    continue block4;
                }
                case '}': {
                    if (i < chars.length && chars[i + 1] == '%') {
                        marker = false;
                        ++i;
                        tpl.addPart(name.toString(), sb.toString());
                        name.setLength(0);
                        sb.setLength(0);
                        continue block4;
                    }
                    if (marker) {
                        name.append(ch);
                        continue block4;
                    }
                    sb.append(ch);
                    continue block4;
                }
                default: {
                    if (marker) {
                        name.append(ch);
                        continue block4;
                    }
                    sb.append(ch);
                }
            }
        }
        tpl.addPart("END", sb.toString());
        return tpl;
    }
}

