/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.elasticsearch.aggregate;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.bucket.MultiBucketsAggregation;
import org.elasticsearch.search.aggregations.bucket.significant.SignificantTermsAggregationBuilder;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.platform.query.api.AggregateDefinition;
import org.nuxeo.ecm.platform.query.core.BucketTerm;
import org.nuxeo.elasticsearch.aggregate.MultiBucketAggregate;

public class SignificantTermAggregate
extends MultiBucketAggregate<BucketTerm> {
    public SignificantTermAggregate(AggregateDefinition definition, DocumentModel searchDocument) {
        super(definition, searchDocument);
    }

    @JsonIgnore
    public SignificantTermsAggregationBuilder getEsAggregate() {
        SignificantTermsAggregationBuilder ret = (SignificantTermsAggregationBuilder)AggregationBuilders.significantTerms((String)this.getId()).field(this.getField());
        Map props = this.getProperties();
        if (props.containsKey("size")) {
            ret.size(this.getAggSize((String)props.get("size")));
        }
        if (props.containsKey("minDocCount")) {
            ret.minDocCount((long)Integer.parseInt((String)props.get("minDocCount")));
        }
        return ret;
    }

    @Override
    @JsonIgnore
    public QueryBuilder getEsFilter() {
        if (this.getSelection().isEmpty()) {
            return null;
        }
        return QueryBuilders.termsQuery((String)this.getField(), (Collection)this.getSelection());
    }

    @Override
    @JsonIgnore
    public void parseEsBuckets(Collection<? extends MultiBucketsAggregation.Bucket> buckets) {
        ArrayList<BucketTerm> nxBuckets = new ArrayList<BucketTerm>(buckets.size());
        for (MultiBucketsAggregation.Bucket bucket : buckets) {
            nxBuckets.add(new BucketTerm(bucket.getKeyAsString(), bucket.getDocCount()));
        }
        this.buckets = nxBuckets;
    }
}

