/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.elasticsearch.client;

import com.carrotsearch.hppc.cursors.ObjectCursor;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.elasticsearch.action.admin.cluster.health.ClusterHealthResponse;
import org.elasticsearch.action.admin.cluster.node.info.NodesInfoResponse;
import org.elasticsearch.action.admin.cluster.node.stats.NodesStatsResponse;
import org.elasticsearch.action.admin.indices.alias.IndicesAliasesRequestBuilder;
import org.elasticsearch.action.admin.indices.alias.exists.AliasesExistResponse;
import org.elasticsearch.action.admin.indices.alias.get.GetAliasesResponse;
import org.elasticsearch.action.admin.indices.delete.DeleteIndexRequest;
import org.elasticsearch.action.admin.indices.exists.indices.IndicesExistsResponse;
import org.elasticsearch.action.admin.indices.mapping.get.GetMappingsResponse;
import org.elasticsearch.action.bulk.BulkProcessor;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.delete.DeleteResponse;
import org.elasticsearch.action.get.GetRequest;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.index.IndexResponse;
import org.elasticsearch.action.search.ClearScrollRequest;
import org.elasticsearch.action.search.ClearScrollResponse;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.SearchScrollRequest;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.transport.NoNodeAvailableException;
import org.elasticsearch.cluster.health.ClusterHealthStatus;
import org.elasticsearch.common.collect.ImmutableOpenMap;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.index.engine.VersionConflictEngineException;
import org.nuxeo.ecm.core.api.ConcurrentUpdateException;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.elasticsearch.api.ESClient;

public class ESTransportClient
implements ESClient {
    private static final Log log = LogFactory.getLog(ESTransportClient.class);
    protected Client client;

    public ESTransportClient(Client client) {
        this.client = client;
    }

    @Override
    public boolean waitForYellowStatus(String[] indexNames, int timeoutSecond) {
        String timeout = timeoutSecond + "s";
        log.debug((Object)("Waiting for cluster yellow health status, indexes: " + Arrays.toString(indexNames)));
        try {
            ClusterHealthResponse response = (ClusterHealthResponse)this.client.admin().cluster().prepareHealth(indexNames).setTimeout(timeout).setWaitForYellowStatus().get();
            if (response.isTimedOut()) {
                throw new NuxeoException("Elasticsearch Cluster health status not Yellow after " + timeout + " give up: " + response);
            }
            if (response.getStatus() != ClusterHealthStatus.GREEN) {
                log.warn((Object)("Elasticsearch Cluster ready but not GREEN: " + response));
                return false;
            }
            log.info((Object)("Elasticsearch Cluster ready: " + response));
        }
        catch (NoNodeAvailableException e) {
            throw new NuxeoException("Failed to connect to elasticsearch, check addressList and clusterName: " + e.getMessage());
        }
        return true;
    }

    @Override
    public ClusterHealthStatus getHealthStatus(String[] indexNames) {
        return ((ClusterHealthResponse)this.client.admin().cluster().prepareHealth(indexNames).get()).getStatus();
    }

    @Override
    public void refresh(String indexName) {
        this.client.admin().indices().prepareRefresh(new String[]{indexName}).get();
    }

    @Override
    public void flush(String indexName) {
        this.client.admin().indices().prepareFlush(new String[]{indexName}).get();
    }

    @Override
    public void optimize(String indexName) {
        this.client.admin().indices().prepareForceMerge(new String[]{indexName}).get();
    }

    @Override
    public boolean indexExists(String indexName) {
        return ((IndicesExistsResponse)this.client.admin().indices().prepareExists(new String[]{indexName}).execute().actionGet()).isExists();
    }

    @Override
    public boolean mappingExists(String indexName, String type) {
        GetMappingsResponse mappings = (GetMappingsResponse)this.client.admin().indices().prepareGetMappings(new String[]{indexName}).execute().actionGet();
        if (mappings == null || mappings.getMappings().isEmpty()) {
            return false;
        }
        return ((ImmutableOpenMap)((ObjectCursor)mappings.getMappings().values().iterator().next()).value).containsKey((Object)type);
    }

    @Override
    public void deleteIndex(String indexName, int timeoutSecond) {
        TimeValue timeout = new TimeValue((long)timeoutSecond, TimeUnit.SECONDS);
        this.client.admin().indices().delete((DeleteIndexRequest)((DeleteIndexRequest)new DeleteIndexRequest(indexName).timeout(timeout)).masterNodeTimeout(timeout)).actionGet();
    }

    @Override
    public void createIndex(String indexName, String jsonSettings) {
        this.client.admin().indices().prepareCreate(indexName).setSettings(jsonSettings, XContentType.JSON).get();
    }

    @Override
    public void createMapping(String indexName, String type, String jsonMapping) {
        this.client.admin().indices().preparePutMapping(new String[]{indexName}).setType(type).setSource(jsonMapping, XContentType.JSON).get();
    }

    @Override
    public String getNodesInfo() {
        return ((NodesInfoResponse)this.client.admin().cluster().prepareNodesInfo(new String[0]).get()).toString();
    }

    @Override
    public String getNodesStats() {
        return ((NodesStatsResponse)this.client.admin().cluster().prepareNodesStats(new String[0]).get()).toString();
    }

    @Override
    public boolean aliasExists(String aliasName) {
        return ((AliasesExistResponse)this.client.admin().indices().prepareAliasesExist(new String[]{aliasName}).get()).isExists();
    }

    @Override
    public String getFirstIndexForAlias(String aliasName) {
        ImmutableOpenMap aliases = ((GetAliasesResponse)this.client.admin().indices().prepareGetAliases(new String[]{aliasName}).get()).getAliases();
        Iterator it = aliases.keysIt();
        while (it.hasNext()) {
            String indexName = (String)it.next();
            if (((List)aliases.get((Object)indexName)).isEmpty()) continue;
            return indexName;
        }
        return null;
    }

    @Override
    public void updateAlias(String aliasName, String indexName) {
        IndicesAliasesRequestBuilder cmd = this.client.admin().indices().prepareAliases();
        if (this.aliasExists(aliasName)) {
            cmd.removeAlias(this.getFirstIndexForAlias(aliasName), aliasName);
        }
        cmd.addAlias(indexName, aliasName).execute().actionGet();
    }

    @Override
    public BulkResponse bulk(BulkRequest request) {
        return (BulkResponse)this.client.bulk(request).actionGet();
    }

    @Override
    public DeleteResponse delete(DeleteRequest request) {
        return (DeleteResponse)this.client.delete(request).actionGet();
    }

    @Override
    public SearchResponse search(SearchRequest request) {
        return (SearchResponse)this.client.search(request).actionGet();
    }

    @Override
    public SearchResponse searchScroll(SearchScrollRequest request) {
        return (SearchResponse)this.client.searchScroll(request).actionGet();
    }

    @Override
    public GetResponse get(GetRequest request) {
        return (GetResponse)this.client.get(request).actionGet();
    }

    @Override
    public IndexResponse index(IndexRequest request) {
        try {
            return (IndexResponse)this.client.index(request).actionGet();
        }
        catch (VersionConflictEngineException e) {
            throw new ConcurrentUpdateException((Throwable)e);
        }
    }

    @Override
    public ClearScrollResponse clearScroll(ClearScrollRequest request) {
        return (ClearScrollResponse)this.client.clearScroll(request).actionGet();
    }

    @Override
    public BulkProcessor.Builder bulkProcessorBuilder(BulkProcessor.Listener listener) {
        return BulkProcessor.builder((Client)this.client, (BulkProcessor.Listener)listener);
    }

    @Override
    public void close() {
        if (this.client != null) {
            this.client.close();
            this.client = null;
        }
    }
}

